/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import edu.umn.biomedicus.framework.SettingImpl;
import edu.umn.biomedicus.framework.SettingsTransformer;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SettingsBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsBinder.class);
    private final Path dataPath;
    private final Path homePath;
    private final Path confPath;
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private Binder binder;

    private SettingsBinder(Path dataPath, Path confPath, Path homePath) {
        this.dataPath = dataPath;
        this.homePath = homePath;
        this.confPath = confPath;
    }

    static SettingsBinder create(Path dataPath, Path confPath, Path homePath) {
        return new SettingsBinder(dataPath, confPath, homePath);
    }

    void addSettings(Map<?, ?> settings) {
        settings.forEach(this::addSetting);
    }

    void addSetting(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalStateException("Setting key without String type: " + key);
        }
        this.settings.put((String)key, value);
    }

    private void performBindings(Binder binder) {
        this.binder = binder;
        binder.bind((TypeLiteral)new TypeLiteral<Map<String, Object>>(){}).annotatedWith((Annotation)Names.named((String)"globalSettings")).toInstance(this.settings);
        binder.bind(new TypeLiteral<Map<String, ?>>(){}).annotatedWith((Annotation)Names.named((String)"globalSettings")).toInstance(this.settings);
        binder.bind(Path.class).annotatedWith((Annotation)new SettingImpl("paths.data")).toInstance((Object)this.dataPath);
        binder.bind(Path.class).annotatedWith((Annotation)new SettingImpl("paths.home")).toInstance((Object)this.homePath);
        binder.bind(Path.class).annotatedWith((Annotation)new SettingImpl("paths.conf")).toInstance((Object)this.confPath);
        SettingsTransformer settingsTransformer = new SettingsTransformer(this.dataPath);
        settingsTransformer.setAnnotationFunction(SettingImpl::new);
        settingsTransformer.addAll(this.settings);
        settingsTransformer.getSettings().forEach(this::bindSetting);
    }

    private <T> void bindSetting(Key<T> key, Object value) {
        if (value instanceof Key) {
            Key valueKey = (Key)value;
            this.binder.bind(key).to(valueKey);
        } else {
            TypeLiteral typeLiteral = key.getTypeLiteral();
            Class rawType = typeLiteral.getRawType();
            Object cast = rawType.cast(value);
            this.binder.bind(key).toInstance(cast);
        }
    }

    Module createModule() {
        return new AbstractModule(){

            protected void configure() {
                SettingsBinder.this.performBindings(this.binder());
            }
        };
    }
}

