/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.SettingsBinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

class SettingsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsLoader.class);
    private final Map<String, Object> configurations = new HashMap<String, Object>();
    @Nullable
    private Map<String, Class<?>> settingInterfaces;
    @Nullable
    private Map<Class<?>, Map<String, Class<?>>> interfaceImplementations;
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private List<String> systemClasses = new ArrayList<String>();

    public SettingsLoader(Map<String, Object> configurations) {
        this.configurations.putAll(configurations);
    }

    static SettingsLoader createSettingsLoader(Path settingsFilePath) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(settingsFilePath);){
            SettingsLoader settingsLoader = new SettingsLoader((Map)new Yaml().load((Reader)bufferedReader));
            return settingsLoader;
        }
    }

    void loadSettings() throws BiomedicusException {
        Object settings;
        Object implementationsYaml;
        Object settingInterfacesYaml;
        Object systems = this.configurations.get("systems");
        if (systems instanceof List) {
            List systemsList = (List)systems;
            for (Object o : systemsList) {
                if (!(o instanceof String)) continue;
                this.systemClasses.add((String)o);
            }
        }
        if ((settingInterfacesYaml = this.configurations.get("settingInterfaces")) instanceof Map) {
            this.settingInterfaces = this.getClassMap((Map)settingInterfacesYaml);
        }
        if ((implementationsYaml = this.configurations.get("interfaceImplementations")) instanceof Map) {
            this.interfaceImplementations = new HashMap();
            for (Map.Entry entry : ((Map)implementationsYaml).entrySet()) {
                try {
                    Object className = entry.getKey();
                    Object interfaceMap = entry.getValue();
                    if (!(className instanceof String) || !(interfaceMap instanceof Map)) continue;
                    Class<?> interfaceClass = Class.forName((String)className);
                    Map interfaceMapYaml = (Map)interfaceMap;
                    Map<String, Class<?>> interfaces = this.getClassMap(interfaceMapYaml);
                    this.interfaceImplementations.put(interfaceClass, interfaces);
                }
                catch (ClassNotFoundException e) {
                    throw new BiomedicusException(e);
                }
            }
        }
        if ((settings = this.configurations.get("settings")) instanceof Map) {
            this.recursiveAddSettings((Map)settings, null);
        }
    }

    private void recursiveAddSettings(Map<?, ?> settingsMap, @Nullable String prevKey) {
        for (Map.Entry<?, ?> settingEntry : settingsMap.entrySet()) {
            Object keyObject = settingEntry.getKey();
            if (!(keyObject instanceof String)) {
                throw new IllegalStateException("Non-String key in settings");
            }
            String entryKey = (String)keyObject;
            String key = prevKey == null ? entryKey : prevKey + "." + entryKey;
            Object value = settingEntry.getValue();
            if (value == null) {
                LOGGER.debug("Null setting: {}", (Object)key);
                continue;
            }
            if (value instanceof Map) {
                this.recursiveAddSettings((Map)value, key);
                continue;
            }
            this.settings.put(key, value);
        }
    }

    private Map<String, Class<?>> getClassMap(Map<?, ?> settingInterfacesYaml) throws BiomedicusException {
        HashMap settingInterfaces = new HashMap();
        for (Map.Entry<?, ?> entry : settingInterfacesYaml.entrySet()) {
            try {
                Object key = entry.getKey();
                Object className = entry.getValue();
                if (key instanceof String && className instanceof String) {
                    Class<?> aClass = Class.forName((String)className);
                    settingInterfaces.put((String)key, aClass);
                    continue;
                }
                LOGGER.warn("Key or value not String in settingInterfaces map. Key: {}. Value: {}", key, className);
            }
            catch (ClassNotFoundException e) {
                throw new BiomedicusException(e);
            }
        }
        return settingInterfaces;
    }

    void addToBinder(SettingsBinder settingsBinder) {
        settingsBinder.addSettings(this.settings);
    }

    List<String> getSystemClasses() {
        return this.systemClasses;
    }
}

