/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Key;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.framework.SettingImpl;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsTransformer.class);
    private final Path dataPath;
    private final Map<Key<?>, Object> settings;
    @Nullable
    private Function<String, Annotation> annotationFunction;

    @Inject
    SettingsTransformer(@Setting(value="paths.data") Path dataPath) {
        this.dataPath = dataPath;
        this.settings = new HashMap();
    }

    void setAnnotationFunction(@Nullable Function<String, Annotation> annotationFunction) {
        this.annotationFunction = annotationFunction;
    }

    void addAll(Map<String, ?> settingsMap) {
        Preconditions.checkNotNull(this.annotationFunction);
        for (Map.Entry<String, ?> settingEntry : settingsMap.entrySet()) {
            String key = settingEntry.getKey();
            Object value = settingEntry.getValue();
            if (value == null) {
                LOGGER.debug("Null setting: {}", (Object)key);
                continue;
            }
            if (value instanceof Map) {
                throw new IllegalStateException("Maps should already be collapsed at this point.");
            }
            if (value instanceof String) {
                this.settings.putIfAbsent(Key.get(String.class, (Annotation)this.annotationFunction.apply(key)), value);
                Path path = Paths.get((String)value, new String[0]);
                this.settings.putIfAbsent(Key.get(Path.class, (Annotation)this.annotationFunction.apply(key + ".asPath")), path);
                if (!path.isAbsolute()) {
                    this.settings.putIfAbsent(Key.get(Path.class, (Annotation)this.annotationFunction.apply(key + ".asDataPath")), this.dataPath.resolve(path));
                    this.settings.putIfAbsent(Key.get(String.class, (Annotation)this.annotationFunction.apply(key + ".asDataPath")), this.dataPath.resolve(path).toString());
                    continue;
                }
                this.settings.putIfAbsent(Key.get(Path.class, (Annotation)this.annotationFunction.apply(key + ".asDataPath")), path);
                this.settings.putIfAbsent(Key.get(String.class, (Annotation)this.annotationFunction.apply(key + ".asDataPath")), path.toString());
                continue;
            }
            this.addSetting(key, value, value.getClass());
        }
    }

    Map<Key<?>, Object> getSettings() {
        return this.settings;
    }

    private <T> void addSettingImplementation(Class<T> interfaceClass, String settingKey, String implementationKey) {
        assert (this.annotationFunction != null) : "checked at entry points";
        Key key = Key.get(interfaceClass, (Annotation)this.annotationFunction.apply(settingKey));
        Key value = Key.get(interfaceClass, (Annotation)new SettingImpl(implementationKey));
        this.settings.putIfAbsent(key, value);
    }

    private <T> void addSetting(String key, Object value, Class<T> valueClass) {
        assert (this.annotationFunction != null) : "checked at entry points";
        this.settings.putIfAbsent(Key.get(valueClass, (Annotation)this.annotationFunction.apply(key)), value);
    }

    private Path absoluteOrResolveAgainstData(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return this.dataPath.resolve(path);
    }

    private boolean endsWithPathFileDir(String key) {
        return key.endsWith("Path") || key.endsWith("path") || key.endsWith("Dir") || key.endsWith("Directory") || key.endsWith("File") || key.endsWith("dir") || key.endsWith("directory") || key.endsWith("file");
    }
}

