/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.io;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactSource;
import edu.umn.nlpengine.StandardArtifact;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ledu/umn/biomedicus/io/JdbcArtifactSource;", "Ledu/umn/nlpengine/ArtifactSource;", "documentName", "", "configFile", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "connection", "Ljava/sql/Connection;", "idColumn", "metadataMappings", "", "resultSet", "Ljava/sql/ResultSet;", "size", "", "statement", "Ljava/sql/Statement;", "textColumn", "close", "", "estimateTotal", "", "tryAdvance", "", "consumer", "Lkotlin/Function1;", "Ledu/umn/nlpengine/Artifact;", "biomedicus-core"})
public final class JdbcArtifactSource
implements ArtifactSource {
    private final Connection connection;
    private final Statement statement;
    private final ResultSet resultSet;
    private final String idColumn;
    private final String textColumn;
    private final Map<String, String> metadataMappings;
    private final int size;
    private final String documentName;
    private final Path configFile;

    public boolean tryAdvance(@NotNull Function1<? super Artifact, Unit> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        if (this.resultSet.next()) {
            String id;
            String string = id = this.resultSet.getString(this.idColumn);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            StandardArtifact artifact = new StandardArtifact(string);
            this.metadataMappings.forEach(new BiConsumer<String, String>(this, artifact){
                final /* synthetic */ JdbcArtifactSource this$0;
                final /* synthetic */ StandardArtifact $artifact;

                public final void accept(@NotNull String column, @NotNull String target) {
                    Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
                    Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                    String metadata = JdbcArtifactSource.access$getResultSet$p(this.this$0).getString(column);
                    if (metadata != null) {
                        Map map = this.$artifact.getMetadata();
                        String string = target;
                        String string2 = metadata;
                        map.put(string, string2);
                    }
                }
                {
                    this.this$0 = jdbcArtifactSource;
                    this.$artifact = standardArtifact;
                }
            });
            String text = this.resultSet.getString(this.textColumn);
            String string2 = text;
            if (string2 == null) {
                string2 = "";
            }
            artifact.addDocument(this.documentName, string2);
            consumer.invoke((Object)artifact);
            return true;
        }
        return false;
    }

    public long estimateTotal() {
        return this.size;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public JdbcArtifactSource(@ComponentSetting(value="documentName") @NotNull String documentName, @ComponentSetting(value="configFile.asPath") @NotNull Path configFile) {
        Intrinsics.checkParameterIsNotNull((Object)documentName, (String)"documentName");
        Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
        this.documentName = documentName;
        this.configFile = configFile;
        Closeable closeable = new FileInputStream(this.configFile.toFile());
        Throwable throwable = null;
        try {
            Object it = (FileInputStream)closeable;
            Object object = new Yaml().load((InputStream)it);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            it = (Map)object;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object config = it;
        Object metadataMap = config.get("metadataMap");
        this.metadataMappings = metadataMap instanceof Map ? (Map)metadataMap : MapsKt.emptyMap();
        Object v = config.get("idColumn");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        this.idColumn = (String)v;
        Object v2 = config.get("textColumn");
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        this.textColumn = (String)v2;
        Object v3 = config.get("driver");
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        Class.forName((String)v3);
        Properties props = new Properties();
        Object v4 = config.get("properties");
        if (v4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<out kotlin.Any, kotlin.Any>");
        }
        props.putAll((Map<?, ?>)((Map)v4));
        Object v5 = config.get("url");
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        Connection connection = DriverManager.getConnection((String)v5, props);
        Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"DriverManager.getConnect\u2026[\"url\"] as String, props)");
        this.connection = connection;
        Statement statement = this.connection.createStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)statement, (String)"connection.createStatement()");
        this.statement = statement;
        Object v6 = config.get("queryFile");
        if (v6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String queryText = FilesKt.readText$default((File)new File((String)v6), null, (int)1, null);
        ResultSet resultSet = this.statement.executeQuery(queryText);
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"statement.executeQuery(queryText)");
        this.resultSet = resultSet;
        Object v7 = config.get("size");
        if (v7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.size = (Integer)v7;
    }

    @NotNull
    public static final /* synthetic */ ResultSet access$getResultSet$p(JdbcArtifactSource $this) {
        return $this.resultSet;
    }
}

