/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.io;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.types.syntax.PartsOfSpeech;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.utilities.PtbReader;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactSource;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.StandardArtifact;
import edu.umn.nlpengine.TextRange;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTBArtifactSource
implements ArtifactSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PTBArtifactSource.class);
    private final Charset charset;
    private final long total;
    private final Spliterator<Path> iterator;
    private final String viewName;

    @Inject
    PTBArtifactSource(@ComponentSetting(value="inputDirectory.asPath") Path directoryPath, @ComponentSetting(value="extension") String extension, @ComponentSetting(value="charsetName") String charsetName, @ComponentSetting(value="documentName") String documentName) throws IOException {
        this.charset = Charset.forName(charsetName);
        this.total = Files.walk(directoryPath, new FileVisitOption[0]).filter(f -> f.toString().endsWith(extension)).count();
        this.iterator = Files.walk(directoryPath, new FileVisitOption[0]).filter(f -> f.toString().endsWith(extension)).spliterator();
        this.viewName = documentName;
    }

    public long estimateTotal() {
        return this.total;
    }

    public void close() {
    }

    public boolean tryAdvance(@Nonnull Function1<? super Artifact, Unit> consumer) {
        return this.iterator.tryAdvance((? super T path) -> {
            String artifactID = path.getFileName().toString();
            StandardArtifact artifact = new StandardArtifact(artifactID);
            ArrayList<Sentence> sentenceLabels = new ArrayList<Sentence>();
            ArrayList<ParseToken> parseTokenLabels = new ArrayList<ParseToken>();
            ArrayList<PosTag> partOfSpeechLabels = new ArrayList<PosTag>();
            StringBuilder documentBuilder = new StringBuilder();
            try {
                Optional<PtbReader.Node> option;
                PtbReader reader = PtbReader.createFromFile(path, this.charset);
                while ((option = reader.nextNode()).isPresent()) {
                    int sentBegin = documentBuilder.length();
                    PtbReader.Node node = option.get();
                    Iterator<PtbReader.Node> leafIterator = node.leafIterator();
                    while (leafIterator.hasNext()) {
                        Optional<String> optionalWord;
                        PtbReader.Node leaf = leafIterator.next();
                        if ("-NONE-".equals(leaf.getLabel()) || !(optionalWord = leaf.getWord()).isPresent()) continue;
                        String word = optionalWord.get();
                        int begin = documentBuilder.length();
                        int end = begin + word.length();
                        Span tokenSpan = new Span(begin, end);
                        documentBuilder.append(word).append(' ');
                        parseTokenLabels.add(new ParseToken((TextRange)tokenSpan, word, true));
                        String label = leaf.getLabel();
                        PartOfSpeech partOfSpeech = PartsOfSpeech.forTagWithFallback(label).orElse(PartOfSpeech.XX);
                        partOfSpeechLabels.add(new PosTag((TextRange)tokenSpan, partOfSpeech));
                    }
                    int sentEnd = documentBuilder.length();
                    sentenceLabels.add(new Sentence(sentBegin, sentEnd));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem reading file: " + path.toString());
            }
            Document document = artifact.addDocument(this.viewName, documentBuilder.toString());
            document.labeler(Sentence.class).addAll(sentenceLabels);
            document.labeler(ParseToken.class).addAll(parseTokenLabels);
            document.labeler(PosTag.class).addAll(partOfSpeechLabels);
            consumer.invoke((Object)artifact);
        });
    }
}

