/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.io;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ledu/umn/biomedicus/io/PlainTextWriter;", "Ledu/umn/nlpengine/DocumentTask;", "outputDirectory", "Ljava/nio/file/Path;", "charsetName", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "Companion", "biomedicus-core"})
public final class PlainTextWriter
implements DocumentTask {
    private final Path outputDirectory;
    private final String charsetName;
    private static final Logger log;
    public static final Companion Companion;

    public void run(@NotNull Document document) {
        Path path;
        Path it;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Path path2 = it = (path = this.outputDirectory.resolve(document.getArtifactID() + ".txt"));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it");
        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDirectory.resolve(\u2026                .toFile()");
        String string = document.getText();
        Charset charset = Charset.forName(this.charsetName);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        FilesKt.writeText((File)file, (String)string, (Charset)charset);
    }

    @Inject
    public PlainTextWriter(@ComponentSetting(value="outputDirectory.asPath") @NotNull Path outputDirectory, @ComponentSetting(value="charset") @NotNull String charsetName) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkParameterIsNotNull((Object)charsetName, (String)"charsetName");
        this.outputDirectory = outputDirectory;
        this.charsetName = charsetName;
        log.debug("Writing plain text files to directory: {}", (Object)this.outputDirectory);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(PlainTextWriter.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ledu/umn/biomedicus/io/PlainTextWriter$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "biomedicus-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

