/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.io;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.TextRange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class PtbTagsWriter
implements DocumentTask {
    private final Path outputDir;

    @Inject
    public PtbTagsWriter(@ComponentSetting(value="writer.ptbTags.outputDir.asPath") Path outputDir) {
        this.outputDir = outputDir;
    }

    public void run(@Nonnull Document document) {
        String documentId = document.getArtifactID();
        String text = document.getText();
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        LabelIndex partOfSpeechLabelIndex = document.labelIndex(PosTag.class);
        StringBuilder rewriter = new StringBuilder(text);
        int added = 0;
        for (ParseToken parseTokenLabel : parseTokenLabelIndex) {
            int end = parseTokenLabel.getEndIndex() + added;
            String insertion = "/" + ((PosTag)partOfSpeechLabelIndex.firstAtLocation((TextRange)parseTokenLabel)).getPartOfSpeech().toString();
            rewriter.insert(end, insertion);
            if (rewriter.charAt(end + insertion.length()) != ' ') {
                rewriter.insert(end + insertion.length(), ' ');
                ++added;
            }
            added += insertion.length();
        }
        try {
            Path fileName = this.outputDir.resolve(documentId);
            Files.write(fileName, rewriter.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

