/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.io;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactSource;
import edu.umn.nlpengine.StandardArtifact;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFilesArtifactSource
implements ArtifactSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFilesArtifactSource.class);
    public static final String SOURCE_PATH = "sourcePath";
    private final Charset charset;
    private final long total;
    private final Spliterator<Path> iterator;
    private final String documentName;
    private final Path inputDirectory;

    @Inject
    TextFilesArtifactSource(@ComponentSetting(value="inputDirectory") String directoryPath, @ComponentSetting(value="extension") String extension, @ComponentSetting(value="charsetName") String charsetName, @ComponentSetting(value="documentName") String documentName) throws IOException {
        this.charset = Charset.forName(charsetName);
        this.inputDirectory = Paths.get(directoryPath, new String[0]);
        this.total = Files.walk(this.inputDirectory, new FileVisitOption[0]).filter(f -> f.toString().endsWith(extension)).count();
        LOGGER.debug("Reading {} files from {}", (Object)this.total, (Object)this.inputDirectory);
        this.iterator = Files.walk(this.inputDirectory, new FileVisitOption[0]).filter(f -> f.toString().endsWith(extension)).spliterator();
        this.documentName = documentName;
    }

    public long estimateTotal() {
        return this.total;
    }

    public void close() {
    }

    public boolean tryAdvance(@Nonnull Function1<? super Artifact, Unit> consumer) {
        return this.iterator.tryAdvance((? super T next) -> {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Reading document: " + next.toString());
            }
            try {
                String s = new String(Files.readAllBytes(next), this.charset);
                String documentId = this.inputDirectory.relativize((Path)next).toString();
                StandardArtifact artifact = new StandardArtifact(documentId);
                artifact.addDocument(this.documentName, s);
                artifact.getMetadata().put(SOURCE_PATH, next.toString());
                consumer.invoke((Object)artifact);
            }
            catch (IOException e) {
                LOGGER.error("Failed on document: " + next.toString());
                throw new IllegalStateException(e);
            }
        });
    }
}

