/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.measures.NumberModelLoader;
import edu.umn.biomedicus.measures.UnitRecognizer;
import edu.umn.biomedicus.numbers.NumberModel;
import java.io.IOException;

public class BiomedicusMeasuresModule
extends AbstractModule {
    protected void configure() {
        this.bind(NumberModel.class).toProvider(NumberModelLoader.class).in(Scopes.SINGLETON);
        this.bind(UnitRecognizer.Factory.class).toProvider(UnitsFactoryLoader.class).in(Scopes.SINGLETON);
        this.bind(UnitRecognizer.class).toProvider(UnitRecognizerProvider.class).in(Scopes.SINGLETON);
    }

    private static final class UnitsFactoryLoader
    extends DataLoader<UnitRecognizer.Factory> {
        private UnitsFactoryLoader() {
        }

        @Override
        protected UnitRecognizer.Factory loadModel() throws BiomedicusException {
            try {
                return UnitRecognizer.createFactory();
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }
    }

    private static final class UnitRecognizerProvider
    implements Provider<UnitRecognizer> {
        private final UnitRecognizer.Factory factory;

        @Inject
        public UnitRecognizerProvider(UnitRecognizer.Factory factory) {
            this.factory = factory;
        }

        public UnitRecognizer get() {
            return this.factory.create();
        }
    }
}

