/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.measures.Number;
import edu.umn.biomedicus.numbers.CombinedNumberDetector;
import edu.umn.biomedicus.numbers.NumberModel;
import edu.umn.biomedicus.numbers.NumberResult;
import edu.umn.biomedicus.numbers.NumberType;
import edu.umn.biomedicus.numbers.Numbers;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class DetectNumbers
implements DocumentTask {
    private final CombinedNumberDetector numberDetector;
    private Labeler<Number> labeler;

    @Inject
    DetectNumbers(NumberModel numberModel, @ComponentSetting(value="measures.numbers.includePercent") boolean includePercent, @ComponentSetting(value="measures.numbers.includeFractions") boolean includeFractions) {
        this.numberDetector = Numbers.createNumberDetector((NumberModel)numberModel);
    }

    void setLabeler(Labeler<Number> labeler) {
        this.labeler = labeler;
    }

    public void run(@Nonnull Document document) {
        LabelIndex sentenceLabelIndex = document.labelIndex(Sentence.class);
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        this.labeler = document.labeler(Number.class);
        for (Sentence sentenceLabel : sentenceLabelIndex) {
            this.extract((Iterable<ParseToken>)parseTokenLabelIndex.inside((TextRange)sentenceLabel));
        }
    }

    void extract(Iterable<ParseToken> labels) {
        for (ParseToken tokenLabel : labels) {
            String text = tokenLabel.getText();
            int begin = tokenLabel.getStartIndex();
            int end = tokenLabel.getEndIndex();
            for (NumberResult numberResult : this.numberDetector.tryToken(text, begin, end)) {
                this.labelSeq(numberResult);
            }
        }
        for (NumberResult numberResult : this.numberDetector.finish()) {
            this.labelSeq(numberResult);
        }
    }

    private void labelSeq(NumberResult numberResult) {
        BigDecimal numerator = numberResult.getNumerator();
        NumberType numberType = numberResult.getNumberType();
        BigDecimal denominator = numberResult.getDenominator();
        if (denominator == null) {
            this.labeler.add((Label)new Number(numberResult.getBegin(), numberResult.getEnd(), numerator.toString(), BigDecimal.ONE.toString(), numberType));
        } else {
            this.labeler.add((Label)new Number(numberResult.getBegin(), numberResult.getEnd(), numerator.toString(), denominator.toString(), numberType));
        }
    }
}

