/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.SequenceDetector;
import edu.umn.biomedicus.measures.FuzzyValue;
import edu.umn.biomedicus.measures.IndefiniteQuantifierCue;
import edu.umn.biomedicus.measures.IndefiniteQuantifierType;
import edu.umn.biomedicus.measures.QuantifiersKt;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007BU\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ledu/umn/biomedicus/measures/IndefiniteQuantifierDetector;", "Ledu/umn/nlpengine/DocumentsProcessor;", "leftPath", "", "rightPath", "localPath", "fuzzyPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "left", "Ledu/umn/biomedicus/common/SequenceDetector;", "Ledu/umn/biomedicus/tokenization/Token;", "right", "local", "fuzzy", "(Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;)V", "process", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class IndefiniteQuantifierDetector
implements DocumentsProcessor {
    private final SequenceDetector<String, Token> left;
    private final SequenceDetector<String, Token> right;
    private final SequenceDetector<String, Token> local;
    private final SequenceDetector<String, Token> fuzzy;

    public void process(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex sentences = $receiver$iv.labelIndex(Sentence.class);
        Document $receiver$iv2 = document;
        LabelIndex tokens = $receiver$iv2.labelIndex(ParseToken.class);
        Document $receiver$iv3 = document;
        Labeler cueLabeler = $receiver$iv3.labeler(IndefiniteQuantifierCue.class);
        Document $receiver$iv4 = document;
        Labeler fuzzyLabeler = $receiver$iv4.labeler(FuzzyValue.class);
        for (Sentence sentence : sentences) {
            IntRange it;
            List sentenceTokens = tokens.inside((TextRange)sentence).asList();
            Iterable $receiver$iv5 = this.left.detectAll(sentenceTokens);
            for (Object element$iv : $receiver$iv5) {
                it = (IntRange)element$iv;
                cueLabeler.add((Label)new IndefiniteQuantifierCue(((ParseToken)sentenceTokens.get(it.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(it.getLast())).getEndIndex(), IndefiniteQuantifierType.LEFT.name()));
            }
            $receiver$iv5 = this.right.detectAll(sentenceTokens);
            for (Object element$iv : $receiver$iv5) {
                it = (IntRange)element$iv;
                cueLabeler.add((Label)new IndefiniteQuantifierCue(((ParseToken)sentenceTokens.get(it.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(it.getLast())).getEndIndex(), IndefiniteQuantifierType.RIGHT.name()));
            }
            $receiver$iv5 = this.local.detectAll(sentenceTokens);
            for (Object element$iv : $receiver$iv5) {
                it = (IntRange)element$iv;
                cueLabeler.add((Label)new IndefiniteQuantifierCue(((ParseToken)sentenceTokens.get(it.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(it.getLast())).getEndIndex(), IndefiniteQuantifierType.LOCAL.name()));
            }
            $receiver$iv5 = this.fuzzy.detectAll(sentenceTokens);
            for (Object element$iv : $receiver$iv5) {
                it = (IntRange)element$iv;
                fuzzyLabeler.add((Label)new FuzzyValue(((ParseToken)sentenceTokens.get(it.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(it.getLast())).getEndIndex()));
            }
        }
    }

    public IndefiniteQuantifierDetector(@NotNull SequenceDetector<String, Token> left, @NotNull SequenceDetector<String, Token> right, @NotNull SequenceDetector<String, Token> local, @NotNull SequenceDetector<String, Token> fuzzy) {
        Intrinsics.checkParameterIsNotNull(left, (String)"left");
        Intrinsics.checkParameterIsNotNull(right, (String)"right");
        Intrinsics.checkParameterIsNotNull(local, (String)"local");
        Intrinsics.checkParameterIsNotNull(fuzzy, (String)"fuzzy");
        this.left = left;
        this.right = right;
        this.local = local;
        this.fuzzy = fuzzy;
    }

    @Inject
    public IndefiniteQuantifierDetector(@Setting(value="measures.indefiniteQuantifiers.left.asDataPath") @NotNull String leftPath, @Setting(value="measures.indefiniteQuantifiers.right.asDataPath") @NotNull String rightPath, @Setting(value="measures.indefiniteQuantifiers.local.asDataPath") @NotNull String localPath, @Setting(value="measures.indefiniteQuantifiers.fuzzy.asDataPath") @NotNull String fuzzyPath) {
        Intrinsics.checkParameterIsNotNull((Object)leftPath, (String)"leftPath");
        Intrinsics.checkParameterIsNotNull((Object)rightPath, (String)"rightPath");
        Intrinsics.checkParameterIsNotNull((Object)localPath, (String)"localPath");
        Intrinsics.checkParameterIsNotNull((Object)fuzzyPath, (String)"fuzzyPath");
        this(SequenceDetector.Factory.loadFromFile(leftPath, QuantifiersKt.access$getTest$p()), SequenceDetector.Factory.loadFromFile(rightPath, QuantifiersKt.access$getTest$p()), SequenceDetector.Factory.loadFromFile(localPath, QuantifiersKt.access$getTest$p()), SequenceDetector.Factory.loadFromFile(fuzzyPath, QuantifiersKt.access$getTest$p()));
    }

    public void done() {
        DocumentsProcessor.DefaultImpls.done((DocumentsProcessor)this);
    }
}

