/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;

public class MeasuresAnnotationTool {
    private static final Pattern SPACE_SPLIT = Pattern.compile(" ");
    private static final Pattern NON_NUMBER = Pattern.compile("[0-9 ]*");
    private static final NumberFormat numberFormat = NumberFormat.getIntegerInstance();
    private final Path inputDir;
    private final Path outputDir;
    private String resumeFile;
    private int resumeIndex;
    private DocumentAnnotations lastDocument;

    public MeasuresAnnotationTool(Path inputDir, Path outputDir) {
        this.inputDir = inputDir;
        this.outputDir = outputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        Throwable throwable;
        this.resumeFile = null;
        if (Files.exists(this.resumeFile(), new LinkOption[0])) {
            throwable = null;
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.resumeFile(), StandardCharsets.UTF_8);){
                this.resumeFile = bufferedReader.readLine();
                String s = bufferedReader.readLine();
                this.resumeIndex = Integer.parseInt(s);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        try {
            throwable = null;
            try (final Scanner scanner = new Scanner(System.in);){
                Files.walkFileTree(this.inputDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!file.toString().endsWith(".txt")) {
                            return FileVisitResult.CONTINUE;
                        }
                        MeasuresAnnotationTool.this.lastDocument = new DocumentAnnotations(file, MeasuresAnnotationTool.this.inputDir, MeasuresAnnotationTool.this.outputDir);
                        if (!MeasuresAnnotationTool.this.lastDocument.checkResume(MeasuresAnnotationTool.this.resumeFile, MeasuresAnnotationTool.this.resumeIndex)) {
                            if (MeasuresAnnotationTool.this.lastDocument.terminate) {
                                System.out.println("Resume data is inconsistent with existing files in the output directory. Seek assistance to prevent data loss.");
                                return FileVisitResult.TERMINATE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        if (MeasuresAnnotationTool.this.resumeFile != null) {
                            MeasuresAnnotationTool.this.resumeFile = null;
                        }
                        try {
                            MeasuresAnnotationTool.this.lastDocument.open();
                            FileVisitResult fileVisitResult = MeasuresAnnotationTool.this.lastDocument.runFile(scanner);
                            return fileVisitResult;
                        }
                        finally {
                            MeasuresAnnotationTool.this.lastDocument.close();
                        }
                    }
                });
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        finally {
            if (this.lastDocument != null) {
                this.lastDocument.writeResume(this.resumeFile());
            }
        }
    }

    private Path resumeFile() {
        return this.outputDir.resolve("resume.txt");
    }

    public static void main(String[] args) {
        Path config = Paths.get("measures.properties", new String[0]);
        Properties properties = new Properties();
        try (InputStream inStream = Files.newInputStream(config, StandardOpenOption.READ);){
            properties.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String inputDirString = properties.getProperty("inputDir");
        if (inputDirString == null) {
            System.out.println("Missing input directory.");
            return;
        }
        Path inputDir = Paths.get(inputDirString, new String[0]);
        Path outputDir = Paths.get(properties.getProperty("outputDir", "."), new String[0]);
        MeasuresAnnotationTool tool = new MeasuresAnnotationTool(inputDir, outputDir);
        try {
            tool.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ExampleQuery {
        private final long exampleNumber;
        private StringBuilder lineBuilder;
        private StringBuilder numbersBuilder;
        private String[] beforeTokens;
        private String[] afterTokens;
        private int tokenCount = 1;
        private int printedCount = 0;
        private boolean retry = false;
        private boolean quit = false;
        private boolean redo = false;

        ExampleQuery(long exampleNumber) {
            this.exampleNumber = exampleNumber;
        }

        private boolean readAndPrintNextContext(BufferedReader bufferedReader) throws IOException {
            String line = bufferedReader.readLine();
            if (line == null) {
                return false;
            }
            System.out.println("Example #" + (this.exampleNumber + 1L));
            this.beforeTokens = SPACE_SPLIT.split(line);
            String[] numberTokens = SPACE_SPLIT.split(bufferedReader.readLine());
            this.afterTokens = SPACE_SPLIT.split(bufferedReader.readLine());
            this.lineBuilder = new StringBuilder();
            this.numbersBuilder = new StringBuilder();
            this.printTokens(this.beforeTokens);
            for (String numberToken : numberTokens) {
                this.lineBuilder.append(numberToken).append(' ');
                this.numbersBuilder.append('#').append(' ');
                for (int i = this.numbersBuilder.length(); i < this.lineBuilder.length(); ++i) {
                    this.numbersBuilder.append(' ');
                }
                this.checkFive();
            }
            this.printTokens(this.afterTokens);
            if (this.lineBuilder.length() > 0) {
                System.out.println(this.lineBuilder.toString());
                System.out.println(this.numbersBuilder.toString());
                System.out.println();
            }
            return true;
        }

        private void printTokens(String[] tokens) {
            for (String beforeToken : tokens) {
                this.lineBuilder.append(beforeToken).append(' ');
                this.numbersBuilder.append(this.tokenCount++).append(' ');
                for (int i = this.numbersBuilder.length(); i < this.lineBuilder.length(); ++i) {
                    this.numbersBuilder.append(' ');
                }
                this.checkFive();
            }
        }

        private void checkFive() {
            while (this.lineBuilder.length() < this.numbersBuilder.length()) {
                this.lineBuilder.append(' ');
            }
            if (++this.printedCount % 100000 == 0) {
                System.out.println(this.lineBuilder.toString());
                System.out.println(this.numbersBuilder.toString());
                System.out.println();
                this.lineBuilder = new StringBuilder();
                this.numbersBuilder = new StringBuilder();
            }
        }

        private String tryCollect(Scanner scanner) {
            StringBuilder measureBuilder;
            block13: {
                measureBuilder = new StringBuilder();
                System.out.print("Is this a measure? ");
                String s = scanner.nextLine();
                if (s.isEmpty()) {
                    return null;
                }
                char firstChar = s.charAt(0);
                if (firstChar == 'Y' || firstChar == 'y') {
                    List<Integer> tokenIndexes;
                    measureBuilder.append('y');
                    while (true) {
                        System.out.print("Which tokens are units? ");
                        tokenIndexes = this.collectIds(scanner);
                        if (tokenIndexes != null) break;
                        if (this.retry) {
                            return this.tryCollect(scanner);
                        }
                        System.out.println("Write each token id that is part of the unit of measure, separated by a space, or the letter u to undo your previous answer.");
                    }
                    measureBuilder.append("\t").append(String.join((CharSequence)" ", () -> tokenIndexes.stream().map(i -> "" + i).iterator()));
                    measureBuilder.append("\t").append(this.grabTokens(tokenIndexes));
                    while (true) {
                        System.out.print("Which tokens are annotations? ");
                        tokenIndexes = this.collectIds(scanner);
                        if (tokenIndexes != null) {
                            measureBuilder.append("\t").append(String.join((CharSequence)" ", () -> tokenIndexes.stream().map(i -> "" + i).iterator()));
                            measureBuilder.append("\t").append(this.grabTokens(tokenIndexes));
                            break block13;
                        }
                        if (this.retry) {
                            return this.tryCollect(scanner);
                        }
                        System.out.println("Write each token id that is an annotation, separated by a space, or the letter u to undo your previous answer");
                    }
                }
                if (firstChar == 'N' || firstChar == 'n') {
                    measureBuilder.append('n');
                } else if (firstChar == 'U' || firstChar == 'u') {
                    measureBuilder.append('u');
                } else {
                    if (firstChar == 'Q' || firstChar == 'q') {
                        this.quit = true;
                        return null;
                    }
                    if (firstChar == 'R' || firstChar == 'r') {
                        this.redo = true;
                        return null;
                    }
                    System.out.println("Respond y for yes, n for no, u for don't know / ambiguous, or q to quit");
                    return null;
                }
            }
            return measureBuilder.toString();
        }

        private List<Integer> collectIds(Scanner scanner) {
            String tokens = scanner.nextLine();
            if (tokens.length() == 0) {
                return Collections.emptyList();
            }
            if ("u".equals(tokens)) {
                this.retry = true;
                return null;
            }
            if (!NON_NUMBER.matcher(tokens).matches()) {
                return null;
            }
            String[] numbers = SPACE_SPLIT.split(tokens);
            ArrayList<Integer> results = new ArrayList<Integer>(numbers.length);
            for (String number : numbers) {
                try {
                    Number parse = numberFormat.parse(number);
                    int i = parse.intValue();
                    if (i <= 0 || i >= this.tokenCount) {
                        return null;
                    }
                    results.add(i);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            return results;
        }

        private String grabTokens(List<Integer> indexes) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer index : indexes) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                if (index <= this.beforeTokens.length) {
                    stringBuilder.append(this.beforeTokens[index - 1]);
                    continue;
                }
                int i = index - this.beforeTokens.length;
                stringBuilder.append(this.afterTokens[i - 1]);
            }
            return stringBuilder.toString();
        }
    }

    private static class DocumentAnnotations
    implements Closeable {
        private final Path relativePath;
        private final Path inputFile;
        private final Path outputFile;
        private long examples = 0L;
        private boolean terminate = false;
        private BufferedReader bufferedReader;
        private BufferedWriter bufferedWriter;
        private String prev;

        DocumentAnnotations(Path inputFile, Path inputDir, Path outputDir) {
            this.relativePath = inputDir.relativize(inputFile);
            this.inputFile = inputFile;
            this.outputFile = outputDir.resolve(this.relativePath);
        }

        private boolean checkResume(String resumeFile, int resumeIndex) throws IOException {
            if (Files.exists(this.outputFile, new LinkOption[0])) {
                long lines;
                if (resumeFile == null) {
                    this.terminate = true;
                    return false;
                }
                if (!resumeFile.equals(this.relativePath.toString())) {
                    return false;
                }
                long l = lines = Files.exists(this.outputFile, new LinkOption[0]) ? Files.lines(this.outputFile).count() : -1L;
                if (lines != (long)resumeIndex) {
                    this.terminate = true;
                    return false;
                }
                this.examples = lines;
            }
            return true;
        }

        private void open() throws IOException {
            this.openReader();
            this.bufferedWriter = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }

        private void openReader() throws IOException {
            this.bufferedReader = Files.newBufferedReader(this.inputFile, StandardCharsets.UTF_8);
            int i = 0;
            while ((long)i < this.examples) {
                this.bufferedReader.readLine();
                this.bufferedReader.readLine();
                this.bufferedReader.readLine();
                ++i;
            }
        }

        private FileVisitResult runFile(Scanner scanner) throws IOException {
            System.out.println("File: " + this.relativePath.toString());
            block0: while (true) {
                String s;
                block6: {
                    ExampleQuery exampleQuery;
                    if (!(exampleQuery = new ExampleQuery(this.examples)).readAndPrintNextContext(this.bufferedReader)) {
                        if (this.prev == null) break;
                        this.bufferedWriter.write(this.prev);
                        this.bufferedWriter.newLine();
                        break;
                    }
                    System.out.flush();
                    do {
                        if ((s = exampleQuery.tryCollect(scanner)) != null) {
                            if (this.prev != null) {
                                this.bufferedWriter.write(this.prev);
                                this.bufferedWriter.newLine();
                            }
                            break block6;
                        }
                        if (!exampleQuery.redo) continue;
                        this.prev = null;
                        --this.examples;
                        this.bufferedReader.close();
                        this.openReader();
                        continue block0;
                    } while (!exampleQuery.quit);
                    if (this.prev != null) {
                        this.bufferedWriter.write(this.prev);
                        this.bufferedWriter.newLine();
                    }
                    return FileVisitResult.TERMINATE;
                }
                this.prev = s;
                System.out.println();
                ++this.examples;
            }
            this.examples = 0L;
            return FileVisitResult.CONTINUE;
        }

        private void writeResume(Path resumeFile) throws IOException {
            try (BufferedWriter resumeWriter = Files.newBufferedWriter(resumeFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                resumeWriter.write(this.relativePath.toString());
                resumeWriter.newLine();
                resumeWriter.write("" + this.examples);
                resumeWriter.newLine();
            }
        }

        @Override
        public void close() throws IOException {
            this.bufferedReader.close();
            this.bufferedWriter.close();
        }
    }
}

