/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.numbers.NumberType;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelMetadata;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@LabelMetadata(classpath="biomedicus.v2", distinct=true)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006!"}, d2={"Ledu/umn/biomedicus/measures/Number;", "Ledu/umn/nlpengine/Label;", "startIndex", "", "endIndex", "numerator", "", "denominator", "numberType", "Ledu/umn/biomedicus/numbers/NumberType;", "(IILjava/lang/String;Ljava/lang/String;Ledu/umn/biomedicus/numbers/NumberType;)V", "getDenominator", "()Ljava/lang/String;", "getEndIndex", "()I", "getNumberType", "()Ledu/umn/biomedicus/numbers/NumberType;", "getNumerator", "getStartIndex", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "value", "Ljava/math/BigDecimal;", "biomedicus-core"})
public final class Number
extends Label {
    private final int startIndex;
    private final int endIndex;
    @NotNull
    private final String numerator;
    @NotNull
    private final String denominator;
    @NotNull
    private final NumberType numberType;

    @NotNull
    public final BigDecimal value() {
        BigDecimal bigDecimal = new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), 4);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"BigDecimal(numerator).di\u2026BigDecimal.ROUND_HALF_UP)");
        return bigDecimal;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @NotNull
    public final String getNumerator() {
        return this.numerator;
    }

    @NotNull
    public final String getDenominator() {
        return this.denominator;
    }

    @NotNull
    public final NumberType getNumberType() {
        return this.numberType;
    }

    public Number(int startIndex, int endIndex, @NotNull String numerator, @NotNull String denominator, @NotNull NumberType numberType) {
        Intrinsics.checkParameterIsNotNull((Object)numerator, (String)"numerator");
        Intrinsics.checkParameterIsNotNull((Object)denominator, (String)"denominator");
        Intrinsics.checkParameterIsNotNull((Object)numberType, (String)"numberType");
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.numerator = numerator;
        this.denominator = denominator;
        this.numberType = numberType;
    }

    public final int component1() {
        return this.getStartIndex();
    }

    public final int component2() {
        return this.getEndIndex();
    }

    @NotNull
    public final String component3() {
        return this.numerator;
    }

    @NotNull
    public final String component4() {
        return this.denominator;
    }

    @NotNull
    public final NumberType component5() {
        return this.numberType;
    }

    @NotNull
    public final Number copy(int startIndex, int endIndex, @NotNull String numerator, @NotNull String denominator, @NotNull NumberType numberType) {
        Intrinsics.checkParameterIsNotNull((Object)numerator, (String)"numerator");
        Intrinsics.checkParameterIsNotNull((Object)denominator, (String)"denominator");
        Intrinsics.checkParameterIsNotNull((Object)numberType, (String)"numberType");
        return new Number(startIndex, endIndex, numerator, denominator, numberType);
    }

    @NotNull
    public static /* synthetic */ Number copy$default(Number number, int n, int n2, String string, String string2, NumberType numberType, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = number.getStartIndex();
        }
        if ((n3 & 2) != 0) {
            n2 = number.getEndIndex();
        }
        if ((n3 & 4) != 0) {
            string = number.numerator;
        }
        if ((n3 & 8) != 0) {
            string2 = number.denominator;
        }
        if ((n3 & 0x10) != 0) {
            numberType = number.numberType;
        }
        return number.copy(n, n2, string, string2, numberType);
    }

    @NotNull
    public String toString() {
        return "Number(startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", numerator=" + this.numerator + ", denominator=" + this.denominator + ", numberType=" + this.numberType + ")";
    }

    public int hashCode() {
        String string = this.numerator;
        String string2 = this.denominator;
        NumberType numberType = this.numberType;
        return (((Integer.hashCode(this.getStartIndex()) * 31 + Integer.hashCode(this.getEndIndex())) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (numberType != null ? numberType.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Number)) break block3;
                Number number = (Number)((Object)object);
                if (!(this.getStartIndex() == number.getStartIndex()) || !(this.getEndIndex() == number.getEndIndex()) || !Intrinsics.areEqual((Object)this.numerator, (Object)number.numerator) || !Intrinsics.areEqual((Object)this.denominator, (Object)number.denominator) || !Intrinsics.areEqual((Object)this.numberType, (Object)number.numberType)) break block3;
            }
            return true;
        }
        return false;
    }
}

