/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.measures.Number;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.TextRange;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class NumberContextWriter
implements DocumentTask {
    private final Path outputDirectory;
    private final int contextSize;

    @Inject
    public NumberContextWriter(@ComponentSetting(value="outputDirectory.asPath") Path outputDirectory, @ComponentSetting(value="contextSize") Integer contextSize) {
        this.outputDirectory = outputDirectory;
        this.contextSize = contextSize;
    }

    public void run(@Nonnull Document document) {
        LabelIndex numbersIndex = document.labelIndex(Number.class);
        LabelIndex sentencesIndex = document.labelIndex(Sentence.class);
        LabelIndex tokensIndex = document.labelIndex(ParseToken.class);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.outputDirectory.resolve(document.getArtifactID() + ".txt"), StandardOpenOption.CREATE_NEW);){
            for (Number number : numbersIndex) {
                LabelIndex sentenceContainingIndex = sentencesIndex.containing((TextRange)number);
                Sentence sentence = (Sentence)sentenceContainingIndex.first();
                if (sentence == null) {
                    throw new RuntimeException("No sentence");
                }
                LabelIndex sentenceTokensIndex = tokensIndex.inside((TextRange)sentence);
                Iterator it = sentenceTokensIndex.backwardFrom((TextRange)number).iterator();
                ArrayList leftTokens = new ArrayList();
                for (int i = 0; i < this.contextSize; ++i) {
                    if (!it.hasNext()) continue;
                    leftTokens.add(it.next());
                }
                int leftSize = leftTokens.size();
                for (int i = 0; i < leftSize; ++i) {
                    bufferedWriter.write(((ParseToken)leftTokens.get(leftSize - 1 - i)).getText() + " ");
                }
                bufferedWriter.newLine();
                for (ParseToken numberToken : tokensIndex.inside((TextRange)number)) {
                    bufferedWriter.write(numberToken.getText() + " ");
                }
                bufferedWriter.newLine();
                Iterator rightIt = sentenceTokensIndex.forwardFrom((TextRange)number).iterator();
                for (int i = 0; i < this.contextSize; ++i) {
                    if (!rightIt.hasNext()) continue;
                    bufferedWriter.write(((ParseToken)rightIt.next()).getText() + " ");
                }
                bufferedWriter.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

