/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.numbers.NumberModel;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NumberModelLoader
extends DataLoader<NumberModel> {
    private final Path nrnumPath;
    private final Path nrvarPath;

    @Inject
    public NumberModelLoader(@Setting(value="measures.numbers.nrnum.asDataPath") Path nrnumPath, @Setting(value="measures.numbers.nrvar.asDataPath") Path nrvarPath) {
        this.nrnumPath = nrnumPath;
        this.nrvarPath = nrvarPath;
    }

    @Override
    protected NumberModel loadModel() throws BiomedicusException {
        try {
            return NumberModel.createNumberModel((Path)this.nrnumPath, (Path)this.nrvarPath);
        }
        catch (IOException e) {
            throw new BiomedicusException(e);
        }
    }
}

