/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.framework.TagEx;
import edu.umn.biomedicus.framework.TagExFactory;
import edu.umn.biomedicus.framework.TagExMatch;
import edu.umn.biomedicus.measures.Quantifier;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.Labeler;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ledu/umn/biomedicus/measures/QuantifierDetector;", "Ledu/umn/nlpengine/DocumentsProcessor;", "factory", "Ledu/umn/biomedicus/framework/TagExFactory;", "(Ledu/umn/biomedicus/framework/TagExFactory;)V", "expr", "Ledu/umn/biomedicus/framework/TagEx;", "(Ledu/umn/biomedicus/framework/TagEx;)V", "process", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class QuantifierDetector
implements DocumentsProcessor {
    private final TagEx expr;

    public void process(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        Labeler labeler = $receiver$iv.labeler(Quantifier.class);
        for (TagExMatch result : this.expr.findAll(document)) {
            boolean isExact = !result.getNamedLabels().containsLabel("indef") && !result.getNamedLabels().containsLabel("fuzz");
            labeler.add((Label)new Quantifier(result, isExact));
        }
    }

    public QuantifierDetector(@NotNull TagEx expr) {
        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
        this.expr = expr;
    }

    @Inject
    public QuantifierDetector(@NotNull TagExFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this(factory.parse("([?indef:IndefiniteQuantifierCue] ->)?\n                                   ([?NumberRange] | [?Number] | [?fuzz:FuzzyValue]\n                                     | [?PosTag<getPartOfSpeech=eDT> ParseToken<getText=\"a\">])"));
    }

    public void done() {
        DocumentsProcessor.DefaultImpls.done((DocumentsProcessor)this);
    }
}

