/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.measures.TimeUnit;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ledu/umn/biomedicus/measures/TimeUnitDetector;", "Ledu/umn/nlpengine/DocumentsProcessor;", "timeUnitsPath", "", "(Ljava/lang/String;)V", "words", "", "(Ljava/util/List;)V", "getWords", "()Ljava/util/List;", "process", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class TimeUnitDetector
implements DocumentsProcessor {
    @NotNull
    private final List<String> words;

    /*
     * WARNING - void declaration
     */
    public void process(@NotNull Document document) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex parseTokens = $receiver$iv.labelIndex(ParseToken.class);
        Object $receiver$iv2 = document;
        Labeler labeler = $receiver$iv2.labeler(TimeUnit.class);
        $receiver$iv2 = (Iterable)parseTokens;
        Object $i$f$labeler = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int n;
            block4: {
                ParseToken it = (ParseToken)element$iv$iv;
                List<String> $receiver$iv3 = this.words;
                int index$iv = 0;
                Iterator<String> iterator2 = $receiver$iv3.iterator();
                while (iterator2.hasNext()) {
                    String item$iv;
                    String tu = item$iv = iterator2.next();
                    if (StringsKt.compareTo((String)it.getText(), (String)tu, (boolean)true) == 0) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            if (!(n != -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        Iterator iterator3 = $receiver$iv2.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            ParseToken it = (ParseToken)element$iv;
            labeler.add((Label)new TimeUnit(it));
        }
    }

    @NotNull
    public final List<String> getWords() {
        return this.words;
    }

    public TimeUnitDetector(@NotNull List<String> words) {
        Intrinsics.checkParameterIsNotNull(words, (String)"words");
        this.words = words;
    }

    @Inject
    public TimeUnitDetector(@Setting(value="measures.timeUnits.asDataPath") @NotNull String timeUnitsPath) {
        Intrinsics.checkParameterIsNotNull((Object)timeUnitsPath, (String)"timeUnitsPath");
        File file = new File(timeUnitsPath);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        this(FilesKt.readLines((File)file, (Charset)charset));
    }

    public void done() {
        DocumentsProcessor.DefaultImpls.done((DocumentsProcessor)this);
    }
}

