/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.modification;

import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.modification.ModificationType;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.TermToken;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class ContextCues {
    private final List<List<String>> leftPhrases;
    private final List<ModificationType> leftTypes;
    private final int maxSizeLeftPhrase;
    private final List<List<String>> rightPhrases;
    private final List<ModificationType> rightTypes;
    private final int maxSizeRightPhrase;
    private final List<PartOfSpeech> scopeDelimitersPos;
    private final List<String> scopeDelimiterWords;

    private ContextCues(List<List<String>> leftPhrases, List<ModificationType> leftTypes, int maxSizeLeftPhrase, List<List<String>> rightPhrases, List<ModificationType> rightTypes, int maxSizeRightPhrase, List<PartOfSpeech> scopeDelimitersPos, List<String> scopeDelimiterWords) {
        this.leftPhrases = leftPhrases;
        this.leftTypes = leftTypes;
        this.maxSizeLeftPhrase = maxSizeLeftPhrase;
        this.rightPhrases = rightPhrases;
        this.rightTypes = rightTypes;
        this.maxSizeRightPhrase = maxSizeRightPhrase;
        this.scopeDelimitersPos = scopeDelimitersPos;
        this.scopeDelimiterWords = scopeDelimiterWords;
    }

    static Builder builder() {
        return new Builder();
    }

    @Nullable
    private Pair<Integer, List<Span>> search(List<TermToken> parseTokenLabels, LabelIndex<PosTag> partOfSpeeches, List<List<String>> phrases, int maxSize) {
        int size = parseTokenLabels.size();
        for (int i = 0; i < size; ++i) {
            TermToken firstParseToken = parseTokenLabels.get(i);
            for (PosTag posTag : partOfSpeeches.inside((TextRange)firstParseToken)) {
                if (!this.scopeDelimitersPos.contains((Object)posTag.getPartOfSpeech())) continue;
                return null;
            }
            String word = firstParseToken.getText();
            if (this.scopeDelimiterWords.contains(word)) {
                return null;
            }
            int limit = Math.min(size - i, maxSize);
            for (int j = i + 1; j <= limit; ++j) {
                List<TermToken> leftRange = parseTokenLabels.subList(i, i + j);
                ArrayList<String> leftSearch = new ArrayList<String>(leftRange.size());
                for (TermToken termToken : leftRange) {
                    leftSearch.add(termToken.getText());
                }
                int indexOf = phrases.indexOf(leftSearch);
                if (indexOf == -1) continue;
                ArrayList<Span> result = new ArrayList<Span>();
                for (TermToken tokenLabel : leftRange) {
                    result.add(tokenLabel.toSpan());
                }
                return new Pair<Integer, List<Span>>(indexOf, result);
            }
        }
        return null;
    }

    @Nullable
    Pair<ModificationType, List<Span>> searchLeft(List<TermToken> parseTokenLabels, LabelIndex<PosTag> partOfSpeeches) {
        Pair<Integer, List<Span>> search = this.search(parseTokenLabels, partOfSpeeches, this.leftPhrases, this.maxSizeLeftPhrase);
        if (search != null) {
            Collections.reverse(search.second());
        }
        return search == null ? null : Pair.of(this.leftTypes.get(search.first()), search.second());
    }

    @Nullable
    Pair<ModificationType, List<Span>> searchRight(List<TermToken> parseTokenLabels, LabelIndex<PosTag> partOfSpeeches) {
        Pair<Integer, List<Span>> search = this.search(parseTokenLabels, partOfSpeeches, this.rightPhrases, this.maxSizeRightPhrase);
        return search == null ? null : Pair.of(this.rightTypes.get(search.getFirst()), search.getSecond());
    }

    static class Builder {
        private final List<List<String>> leftPhrases = new ArrayList<List<String>>();
        private final List<ModificationType> leftTypes = new ArrayList<ModificationType>();
        private final List<List<String>> rightPhrases = new ArrayList<List<String>>();
        private final List<ModificationType> rightTypes = new ArrayList<ModificationType>();
        private final List<PartOfSpeech> scopeDelimitersPos = new ArrayList<PartOfSpeech>();
        private final List<String> scopeDelimiterWords = new ArrayList<String>();
        private int maxSizeLeftPhrase = 0;
        private int maxSizeRightPhrase = 0;

        Builder() {
        }

        Builder addRightPhrase(ModificationType modificationType, String ... words) {
            if (words.length > this.maxSizeRightPhrase) {
                this.maxSizeRightPhrase = words.length;
            }
            this.rightPhrases.add(Arrays.asList(words));
            this.rightTypes.add(modificationType);
            return this;
        }

        Builder addLeftPhrase(ModificationType modificationType, String ... words) {
            if (words.length > this.maxSizeLeftPhrase) {
                this.maxSizeLeftPhrase = words.length;
            }
            List<String> wordsList = Arrays.asList(words);
            Collections.reverse(wordsList);
            this.leftPhrases.add(wordsList);
            this.leftTypes.add(modificationType);
            return this;
        }

        Builder addScopeDelimitingPos(PartOfSpeech partOfSpeech) {
            this.scopeDelimitersPos.add(partOfSpeech);
            return this;
        }

        Builder addScopeDelimitingWord(String word) {
            this.scopeDelimiterWords.add(word);
            return this;
        }

        ContextCues build() {
            return new ContextCues(this.leftPhrases, this.leftTypes, this.maxSizeLeftPhrase, this.rightPhrases, this.rightTypes, this.maxSizeRightPhrase, this.scopeDelimitersPos, this.scopeDelimiterWords);
        }
    }
}

