/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.modification;

import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.concepts.DictionaryTerm;
import edu.umn.biomedicus.modification.ContextCues;
import edu.umn.biomedicus.modification.Historical;
import edu.umn.biomedicus.modification.ModificationCue;
import edu.umn.biomedicus.modification.ModificationType;
import edu.umn.biomedicus.modification.Negated;
import edu.umn.biomedicus.modification.Probable;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.TermToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DetectModifiers
implements DocumentTask {
    private static final ContextCues CUES = ContextCues.builder().addLeftPhrase(ModificationType.HISTORICAL, "History").addLeftPhrase(ModificationType.HISTORICAL, "history").addLeftPhrase(ModificationType.HISTORICAL, "Historical").addLeftPhrase(ModificationType.HISTORICAL, "historical").addLeftPhrase(ModificationType.HISTORICAL, "Histories").addLeftPhrase(ModificationType.HISTORICAL, "histories").addLeftPhrase(ModificationType.HISTORICAL, "Status", "Post").addLeftPhrase(ModificationType.HISTORICAL, "Status", "post").addLeftPhrase(ModificationType.HISTORICAL, "status", "post").addLeftPhrase(ModificationType.HISTORICAL, "S/P").addLeftPhrase(ModificationType.HISTORICAL, "s/p").addLeftPhrase(ModificationType.HISTORICAL, "S-P").addLeftPhrase(ModificationType.HISTORICAL, "s-p").addLeftPhrase(ModificationType.HISTORICAL, "S.P.").addLeftPhrase(ModificationType.HISTORICAL, "s.p.").addLeftPhrase(ModificationType.HISTORICAL, "SP").addLeftPhrase(ModificationType.HISTORICAL, "sp").addRightPhrase(ModificationType.HISTORICAL, "History").addRightPhrase(ModificationType.HISTORICAL, "history").addLeftPhrase(ModificationType.NEGATED, "No").addLeftPhrase(ModificationType.NEGATED, "no").addLeftPhrase(ModificationType.NEGATED, "Deny").addLeftPhrase(ModificationType.NEGATED, "deny").addLeftPhrase(ModificationType.NEGATED, "Denies").addLeftPhrase(ModificationType.NEGATED, "denies").addLeftPhrase(ModificationType.NEGATED, "Denying").addLeftPhrase(ModificationType.NEGATED, "denying").addLeftPhrase(ModificationType.NEGATED, "Absent").addLeftPhrase(ModificationType.NEGATED, "absent").addLeftPhrase(ModificationType.NEGATED, "Negative").addLeftPhrase(ModificationType.NEGATED, "negative").addLeftPhrase(ModificationType.NEGATED, "Without").addLeftPhrase(ModificationType.NEGATED, "without").addLeftPhrase(ModificationType.NEGATED, "w/o").addLeftPhrase(ModificationType.NEGATED, "W/O").addLeftPhrase(ModificationType.NEGATED, "Never").addLeftPhrase(ModificationType.NEGATED, "never").addLeftPhrase(ModificationType.NEGATED, "Unremarkable").addLeftPhrase(ModificationType.NEGATED, "unremarkable").addLeftPhrase(ModificationType.NEGATED, "Un-remarkable").addLeftPhrase(ModificationType.NEGATED, "un-remarkable").addRightPhrase(ModificationType.NEGATED, "none").addRightPhrase(ModificationType.NEGATED, "negative").addRightPhrase(ModificationType.NEGATED, "absent").addLeftPhrase(ModificationType.PROBABLE, "Possible").addLeftPhrase(ModificationType.PROBABLE, "possible").addLeftPhrase(ModificationType.PROBABLE, "Possibly").addLeftPhrase(ModificationType.PROBABLE, "possibly").addLeftPhrase(ModificationType.PROBABLE, "Probable").addLeftPhrase(ModificationType.PROBABLE, "probable").addLeftPhrase(ModificationType.PROBABLE, "Probably").addLeftPhrase(ModificationType.PROBABLE, "probably").addLeftPhrase(ModificationType.PROBABLE, "Might").addLeftPhrase(ModificationType.PROBABLE, "might").addLeftPhrase(ModificationType.PROBABLE, "likely").addLeftPhrase(ModificationType.PROBABLE, "Likely").addLeftPhrase(ModificationType.PROBABLE, "am", "not", "sure").addLeftPhrase(ModificationType.PROBABLE, "Am", "not", "sure").addLeftPhrase(ModificationType.PROBABLE, "Not", "sure").addLeftPhrase(ModificationType.PROBABLE, "not", "sure").addLeftPhrase(ModificationType.PROBABLE, "Differential").addLeftPhrase(ModificationType.PROBABLE, "differential").addLeftPhrase(ModificationType.PROBABLE, "Uncertain").addLeftPhrase(ModificationType.PROBABLE, "uncertain").addLeftPhrase(ModificationType.PROBABLE, "chance").addLeftPhrase(ModificationType.PROBABLE, "Chance").addRightPhrase(ModificationType.PROBABLE, "likely").addRightPhrase(ModificationType.PROBABLE, "probable").addRightPhrase(ModificationType.PROBABLE, "unlikely").addRightPhrase(ModificationType.PROBABLE, "possible").addRightPhrase(ModificationType.PROBABLE, "uncertain").addScopeDelimitingPos(PartOfSpeech.WDT).addScopeDelimitingPos(PartOfSpeech.PRP).addScopeDelimitingPos(PartOfSpeech.VBZ).addScopeDelimitingWord("but").addScopeDelimitingWord("however").addScopeDelimitingWord("therefore").addScopeDelimitingWord("otherwise").addScopeDelimitingWord("except").addScopeDelimitingWord(";").addScopeDelimitingWord(":").build();

    public void run(@Nonnull Document document) {
        LabelIndex tokenLabelIndex = document.labelIndex(TermToken.class);
        LabelIndex dictionaryTermLabelIndex = document.labelIndex(DictionaryTerm.class);
        LabelIndex sentenceLabelIndex = document.labelIndex(Sentence.class);
        LabelIndex partOfSpeechLabelIndex = document.labelIndex(PosTag.class);
        Labeler probableLabeler = document.labeler(Probable.class);
        Labeler historicalLabeler = document.labeler(Historical.class);
        Labeler negatedLabeler = document.labeler(Negated.class);
        Labeler cueLabeler = document.labeler(ModificationCue.class);
        block10: for (DictionaryTerm termLabel : dictionaryTermLabelIndex) {
            List<ModificationCue> cues;
            Sentence sentenceLabel = (Sentence)sentenceLabelIndex.containing((TextRange)termLabel).first();
            if (sentenceLabel == null) {
                sentenceLabelIndex.containing((TextRange)termLabel);
                throw new RuntimeException("Term outside of a sentence.");
            }
            LabelIndex sentenceTokenLabels = tokenLabelIndex.inside((TextRange)sentenceLabel);
            List contextList = sentenceTokenLabels.backwardFrom((TextRange)termLabel).asList();
            Pair<ModificationType, List<Span>> result = CUES.searchLeft(contextList, (LabelIndex<PosTag>)partOfSpeechLabelIndex);
            if (result != null) {
                cues = result.second().stream().map(span -> {
                    ModificationCue cue = new ModificationCue((TextRange)span);
                    cueLabeler.add((Label)cue);
                    return cue;
                }).collect(Collectors.toList());
                switch (result.first()) {
                    case HISTORICAL: {
                        historicalLabeler.add((Label)new Historical((TextRange)termLabel, cues));
                        continue block10;
                    }
                    case NEGATED: {
                        negatedLabeler.add((Label)new Negated((TextRange)termLabel, cues));
                        continue block10;
                    }
                    case PROBABLE: {
                        probableLabeler.add((Label)new Probable((TextRange)termLabel, cues));
                        continue block10;
                    }
                }
                throw new IllegalStateException();
            }
            contextList = sentenceTokenLabels.forwardFrom((TextRange)termLabel).asList();
            result = CUES.searchRight(contextList, (LabelIndex<PosTag>)partOfSpeechLabelIndex);
            if (result == null) continue;
            cues = result.second().stream().map(span -> {
                ModificationCue cue = new ModificationCue((TextRange)span);
                cueLabeler.add((Label)cue);
                return cue;
            }).collect(Collectors.toList());
            switch (result.first()) {
                case HISTORICAL: {
                    historicalLabeler.add((Label)new Historical((TextRange)termLabel, cues));
                    continue block10;
                }
                case NEGATED: {
                    negatedLabeler.add((Label)new Negated((TextRange)termLabel, cues));
                    continue block10;
                }
                case PROBABLE: {
                    probableLabeler.add((Label)new Probable((TextRange)termLabel, cues));
                    continue block10;
                }
            }
            throw new IllegalStateException();
        }
    }
}

