/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.normalization;

import com.google.inject.Inject;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.normalization.NormForm;
import edu.umn.biomedicus.normalization.NormalizerModel;
import edu.umn.biomedicus.normalization.TermPos;
import edu.umn.biomedicus.normalization.TermString;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.WordIndex;
import edu.umn.biomedicus.vocabulary.Vocabulary;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Normalizer
implements DocumentsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Normalizer.class);
    private final NormalizerModel normalizerStore;
    private final BidirectionalDictionary normsIndex;

    @Inject
    public Normalizer(NormalizerModel normalizerStore, Vocabulary vocabulary) {
        this.normalizerStore = normalizerStore;
        this.normsIndex = vocabulary.getNormsIndex();
    }

    public void process(@Nonnull Document document) {
        LOGGER.debug("Normalizing tokens in a document.");
        LabelIndex wordIndexLabelIndex = document.labelIndex(WordIndex.class);
        LabelIndex posTagIndex = document.labelIndex(PosTag.class);
        Labeler normFormLabeler = document.labeler(NormForm.class);
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        for (WordIndex wordIndex : wordIndexLabelIndex) {
            StringIdentifier normTerm;
            String norm;
            PartOfSpeech partOfSpeech = ((PosTag)posTagIndex.firstAtLocation((TextRange)wordIndex)).getPartOfSpeech();
            StringIdentifier wordTerm = wordIndex.getStringIdentifier();
            TermString normAndTerm = null;
            if (!wordTerm.isUnknown()) {
                normAndTerm = this.normalizerStore.get(new TermPos(wordTerm, partOfSpeech));
            }
            if (normAndTerm == null) {
                norm = ((ParseToken)parseTokenLabelIndex.firstAtLocation((TextRange)wordIndex)).getText().toLowerCase();
                normTerm = this.normsIndex.getTermIdentifier(norm);
            } else {
                norm = normAndTerm.getString();
                normTerm = normAndTerm.getTerm();
            }
            normFormLabeler.add((Label)new NormForm((TextRange)wordIndex, norm, normTerm));
        }
    }

    public void done() {
    }
}

