/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.normalization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.normalization.NormalizerModel;
import edu.umn.biomedicus.normalization.RocksDBNormalizerModel;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class NormalizerModelLoader
extends DataLoader<NormalizerModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizerModelLoader.class);
    private final Path dbPath;
    private final boolean inMemory;

    @Inject
    NormalizerModelLoader(@Setting(value="normalization.db.asDataPath") Path dbPath, @Setting(value="normalization.inMemory") boolean inMemory) {
        this.dbPath = dbPath;
        this.inMemory = inMemory;
    }

    @Override
    protected NormalizerModel loadModel() {
        LOGGER.info("Loading normalization model: {}. inMemory = {}.", (Object)this.dbPath, (Object)this.inMemory);
        return new RocksDBNormalizerModel(this.dbPath).inMemory(this.inMemory);
    }
}

