/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.normalization;

import edu.umn.biomedicus.normalization.HashNormalizerModel;
import edu.umn.biomedicus.normalization.NormalizerModel;
import edu.umn.biomedicus.normalization.TermPos;
import edu.umn.biomedicus.normalization.TermString;
import java.nio.file.Path;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBNormalizerModel
implements NormalizerModel {
    private final RocksDB db;

    RocksDBNormalizerModel(Path dbPath) {
        RocksDB.loadLibrary();
        try (Options options = new Options().setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);){
            this.db = RocksDB.openReadOnly((Options)options, (String)dbPath.toString());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public TermString get(@Nullable TermPos termPos) {
        if (termPos == null) {
            return null;
        }
        byte[] key = termPos.getBytes();
        try {
            byte[] bytes = this.db.get(key);
            return bytes == null ? null : new TermString(bytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doShutdown() {
        this.db.close();
    }

    NormalizerModel inMemory(boolean inMemory) {
        if (!inMemory) {
            return this;
        }
        HashMap<TermPos, TermString> map = new HashMap<TermPos, TermString>();
        try (RocksIterator rocksIterator = this.db.newIterator();){
            rocksIterator.seekToFirst();
            while (rocksIterator.isValid()) {
                TermPos termPos = new TermPos(rocksIterator.key());
                TermString termString = new TermString(rocksIterator.value());
                map.put(termPos, termString);
                rocksIterator.next();
            }
        }
        return new HashNormalizerModel(map);
    }
}

