/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.normalization;

import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

final class TermPos
implements Comparable<TermPos> {
    private static final int BYTES = 8;
    private final int indexedTerm;
    private final PartOfSpeech partOfSpeech;

    TermPos(StringIdentifier termIdentifier, PartOfSpeech partOfSpeech) {
        this.indexedTerm = termIdentifier.value();
        this.partOfSpeech = partOfSpeech;
    }

    TermPos(byte[] bytes) {
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        this.indexedTerm = wrap.getInt();
        this.partOfSpeech = PartOfSpeech.values()[wrap.getInt()];
    }

    StringIdentifier getIndexedTerm() {
        return new StringIdentifier(this.indexedTerm);
    }

    PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermPos termPos = (TermPos)o;
        if (this.indexedTerm != termPos.indexedTerm) {
            return false;
        }
        return this.partOfSpeech == termPos.partOfSpeech;
    }

    public int hashCode() {
        int result = this.indexedTerm;
        result = 31 * result + this.partOfSpeech.hashCode();
        return result;
    }

    @Override
    public int compareTo(@Nonnull TermPos o) {
        int compare = Integer.compare(this.indexedTerm, o.indexedTerm);
        if (compare != 0) {
            return compare;
        }
        return this.partOfSpeech.compareTo(o.partOfSpeech);
    }

    byte[] getBytes() {
        return ByteBuffer.allocate(8).putInt(this.indexedTerm).putInt(this.partOfSpeech.ordinal()).array();
    }
}

