/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.normalization;

import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

final class TermString {
    private final int term;
    private final String string;

    TermString(StringIdentifier term, String string) {
        this.term = term.value();
        this.string = string;
    }

    TermString(byte[] bytes) {
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        this.term = wrap.getInt();
        byte[] stringBytes = new byte[wrap.remaining()];
        wrap.get(stringBytes);
        this.string = new String(stringBytes, StandardCharsets.UTF_8);
    }

    StringIdentifier getTerm() {
        return new StringIdentifier(this.term);
    }

    String getString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermString that = (TermString)o;
        if (this.term != that.term) {
            return false;
        }
        return this.string.equals(that.string);
    }

    public int hashCode() {
        int result = this.term;
        result = 31 * result + this.string.hashCode();
        return result;
    }

    byte[] getBytes() {
        byte[] stringBytes = this.string.getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(stringBytes.length + 4).putInt(this.term).put(stringBytes).array();
    }
}

