/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.python;

import edu.umn.biomedicus.annotations.Setting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB9\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0001\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0012\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ledu/umn/biomedicus/python/PythonEnvironment;", "", "pythonHome", "Ljava/nio/file/Path;", "pyExec", "", "newt", "biomedicus", "kc", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "bioDist", "kcDist", "newtDist", "script", "venv", "createProcessBuilder", "Ljava/lang/ProcessBuilder;", "args", "", "([Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "install", "", "installCheck", "writeErrorStream", "process", "Ljava/lang/Process;", "Companion", "biomedicus-core"})
public final class PythonEnvironment {
    private final Path venv;
    private final Path script;
    private final Path bioDist;
    private final Path kcDist;
    private final Path newtDist;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final ProcessBuilder createProcessBuilder(String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)((Object)this.script).toString());
        spreadBuilder.add((Object)((Object)this.venv.resolve("bin").resolve("activate")).toString());
        spreadBuilder.addSpread((Object)args);
        return new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    public final void installCheck() {
        Process biomedicusCheck = this.createProcessBuilder("-c", "\"import biomedicus\"").start();
        if (biomedicusCheck.waitFor() != 0) {
            this.install();
        }
    }

    public final void install() {
        logger.info("Installing keras_contrib for biomedicus python");
        Process kcInstall = this.createProcessBuilder("-m", "pip", "install", ((Object)this.kcDist).toString()).start();
        if (kcInstall.waitFor() != 0) {
            Process process2 = kcInstall;
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"kcInstall");
            this.writeErrorStream(process2);
            String string = "Non-zero exit code installing keras-contrib";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        logger.info("Installing tensorflow for biomedicus python");
        Process tfInstall = this.createProcessBuilder("-m", "pip", "install", "tensorflow").start();
        if (tfInstall.waitFor() != 0) {
            Process process3 = tfInstall;
            Intrinsics.checkExpressionValueIsNotNull((Object)process3, (String)"tfInstall");
            this.writeErrorStream(process3);
            String string = "Non-zero exit code installing tensorflow";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        logger.info("Installing nlp-newt for biomedicus python");
        Process newtInstall = this.createProcessBuilder("-m", "pip", "install", ((Object)this.newtDist).toString()).start();
        if (newtInstall.waitFor() != 0) {
            Process process4 = newtInstall;
            Intrinsics.checkExpressionValueIsNotNull((Object)process4, (String)"newtInstall");
            this.writeErrorStream(process4);
            String string = "Non-zero exit code installing nlp-newt";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        logger.info("Installing biomedicus python");
        Process bioInstall = this.createProcessBuilder("-m", "pip", "install", ((Object)this.bioDist).toString()).start();
        if (bioInstall.waitFor() != 0) {
            Process process5 = bioInstall;
            Intrinsics.checkExpressionValueIsNotNull((Object)process5, (String)"bioInstall");
            this.writeErrorStream(process5);
            String string = "Non-zero exit code installing biomedicus";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeErrorStream(Process process2) {
        Reader $receiver$iv;
        Closeable closeable = $receiver$iv = (Reader)new BufferedReader(new InputStreamReader(process2.getErrorStream()));
        int n = 8192;
        closeable = (BufferedReader)closeable;
        Throwable throwable = null;
        try {
            Sequence it;
            BufferedReader it$iv = (BufferedReader)closeable;
            Sequence $receiver$iv2 = it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            for (Object element$iv : $receiver$iv2) {
                String it2 = (String)element$iv;
                logger.error(it2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public PythonEnvironment(@Setting(value="python.home.asDataPath") @NotNull Path pythonHome, @Setting(value="python.executable") @NotNull String pyExec, @Setting(value="python.nlpnewt.dist") @NotNull String newt, @Setting(value="python.biomedicus") @NotNull String biomedicus, @Setting(value="python.keras_contrib") @NotNull String kc) {
        Intrinsics.checkParameterIsNotNull((Object)pythonHome, (String)"pythonHome");
        Intrinsics.checkParameterIsNotNull((Object)pyExec, (String)"pyExec");
        Intrinsics.checkParameterIsNotNull((Object)newt, (String)"newt");
        Intrinsics.checkParameterIsNotNull((Object)biomedicus, (String)"biomedicus");
        Intrinsics.checkParameterIsNotNull((Object)kc, (String)"kc");
        Path path = pythonHome.resolve("venv");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"pythonHome.resolve(\"venv\")");
        this.venv = path;
        Path path2 = pythonHome.resolve("pyRun.sh");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"pythonHome.resolve(\"pyRun.sh\")");
        this.script = path2;
        Path path3 = pythonHome.resolve(biomedicus);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"pythonHome.resolve(biomedicus)");
        this.bioDist = path3;
        Path path4 = pythonHome.resolve(kc);
        Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"pythonHome.resolve(kc)");
        this.kcDist = path4;
        Path path5 = pythonHome.resolve(newt);
        Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"pythonHome.resolve(newt)");
        this.newtDist = path5;
        if (Files.notExists(this.venv, new LinkOption[0])) {
            Process installVenv = new ProcessBuilder(pyExec, "-m", "pip", "install", "virtualenv").start();
            int venvExit = installVenv.waitFor();
            if (venvExit != 0) {
                Process process2 = installVenv;
                Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"installVenv");
                this.writeErrorStream(process2);
                String string = "Non-zero exit code while trying to create the virtual environment";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Process createVenv = new ProcessBuilder(pyExec, "-m", "virtualenv", ((Object)this.venv).toString()).start();
            int exit = createVenv.waitFor();
            if (exit != 0) {
                Process process3 = createVenv;
                Intrinsics.checkExpressionValueIsNotNull((Object)process3, (String)"createVenv");
                this.writeErrorStream(process3);
                String string = "Non-zero exit code while trying to create the virtual environment";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(PythonEnvironment.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ledu/umn/biomedicus/python/PythonEnvironment$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "biomedicus-core"})
    public static final class Companion {
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

