/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sections;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.common.utilities.Patterns;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.formatting.Bold;
import edu.umn.biomedicus.formatting.Underlined;
import edu.umn.biomedicus.sections.SectionHeader;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class RuleBasedSectionHeaderDetector
implements DocumentsProcessor {
    private final Pattern headers;

    @Inject
    RuleBasedSectionHeaderDetector(@ComponentSetting(value="sections.headers.asDataPath") Path path) throws BiomedicusException {
        this.headers = Patterns.loadPatternByJoiningLines(path);
    }

    public void process(@Nonnull Document document) {
        LabelIndex sentenceLabelIndex = document.labelIndex(Sentence.class);
        LabelIndex boldLabelIndex = document.labelIndex(Bold.class);
        LabelIndex underlinedLabelIndex = document.labelIndex(Underlined.class);
        Labeler headerLabeler = document.labeler(SectionHeader.class);
        String text = document.getText();
        for (Sentence sentenceLabel : sentenceLabelIndex) {
            CharSequence sentenceText = sentenceLabel.coveredText(text);
            if (!this.headers.matcher(sentenceText).find() && boldLabelIndex.atLocation((TextRange)sentenceLabel).isEmpty() && underlinedLabelIndex.atLocation((TextRange)sentenceLabel).isEmpty()) continue;
            headerLabeler.add((Label)new SectionHeader((TextRange)sentenceLabel));
        }
    }

    public void done() {
    }
}

