/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentence;

import edu.umn.biomedicus.common.utilities.Patterns;
import edu.umn.biomedicus.sentence.ONLPSentenceModel;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sentences.TextSegment;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.Collections;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.util.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ONLPDetectSentences
implements DocumentTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ONLPDetectSentences.class);
    private final SentenceDetectorME sentenceDetector;

    @Inject
    ONLPDetectSentences(ONLPSentenceModel ONLPSentenceModel2) {
        this.sentenceDetector = ONLPSentenceModel2.createSentenceDetector();
    }

    public void run(@Nonnull Document document) {
        String text = document.getText();
        Labeler sentenceLabeler = document.labeler(Sentence.class);
        LabelIndex textSegmentLabelIndex = document.labelIndex(TextSegment.class);
        Object segments = textSegmentLabelIndex.isEmpty() ? Collections.singleton(new TextSegment(0, text.length())) : textSegmentLabelIndex;
        for (TextRange segment : segments) {
            Matcher finalWhitespace;
            String segmentText;
            if (segment.length() == 0 || !Patterns.NON_WHITESPACE.matcher(segmentText = segment.coveredString(text)).find()) continue;
            Matcher initialWhitespace = Patterns.INITIAL_WHITESPACE.matcher(segmentText);
            if (initialWhitespace.find()) {
                segmentText = segmentText.substring(initialWhitespace.end());
                segment = new edu.umn.nlpengine.Span(segment.getStartIndex() + initialWhitespace.end(), segment.getEndIndex());
            }
            if ((finalWhitespace = Patterns.FINAL_WHITESPACE.matcher(segmentText)).find()) {
                segmentText = segmentText.substring(0, finalWhitespace.start());
                segment = new edu.umn.nlpengine.Span(segment.getStartIndex(), segment.getStartIndex() + finalWhitespace.start());
            }
            if (segment.length() == 0) continue;
            LOGGER.trace("Detecting sentences: {}", (Object)segmentText);
            for (Span onlpSpan : this.sentenceDetector.sentPosDetect(segmentText)) {
                edu.umn.nlpengine.Span span = new edu.umn.nlpengine.Span(onlpSpan.getStart(), onlpSpan.getEnd()).offsetRightByStartIndex(segment);
                if (!Patterns.NON_WHITESPACE.matcher(span.coveredString(text)).find()) continue;
                sentenceLabeler.add((Label)new Sentence((TextRange)span));
            }
        }
    }
}

