/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentence;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;

@Singleton
@ProvidedBy(value=Loader.class)
public class ONLPSentenceModel {
    private SentenceModel model;

    private ONLPSentenceModel(SentenceModel model) {
        this.model = model;
    }

    SentenceDetectorME createSentenceDetector() {
        return new SentenceDetectorME(this.model);
    }

    @Singleton
    public static class Loader
    extends DataLoader<ONLPSentenceModel> {
        private final Path path;

        @Inject
        public Loader(@Setting(value="opennlp.sentence.model.asDataPath") Path path) {
            this.path = path;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected ONLPSentenceModel loadModel() throws BiomedicusException {
            try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
                SentenceModel sentenceModel = new SentenceModel(inputStream);
                ONLPSentenceModel oNLPSentenceModel = new ONLPSentenceModel(sentenceModel);
                return oNLPSentenceModel;
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }
    }
}

