/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentence;

import edu.umn.biomedicus.acronym.AcronymExpansionsModel;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactsProcessor;
import edu.umn.nlpengine.Document;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringList;
import opennlp.tools.util.TrainingParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ONLPSentenceTrainer
implements ArtifactsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ONLPSentenceTrainer.class);
    private static final String POISON = ">poison<";
    private final BlockingDeque<String> samplesQueue = new LinkedBlockingDeque<String>();
    private final Dictionary abbrevs;
    private final Path outputPath;
    private final CountDownLatch modelTrained = new CountDownLatch(1);
    private final String documentName;
    private final Boolean useUnsure;
    @Nullable
    private SentenceModel sentenceModel = null;
    @Nullable
    private IOException ioException = null;

    @Inject
    ONLPSentenceTrainer(AcronymExpansionsModel acronymExpansionsModel, @ComponentSetting(value="outputDirectory.asPath") Path outputPath, @ComponentSetting(value="documentName") String documentName, @ComponentSetting(value="eosChars") String eosChars, @ComponentSetting(value="useTokenEnd") Boolean useTokenEnd, @ComponentSetting(value="useNewlineAsEos") Boolean useNewlineAsEos, @ComponentSetting(value="useTabAsEos") Boolean useTabAsEos, @ComponentSetting(value="useUnsure") Boolean useUnsure) {
        this.outputPath = outputPath;
        this.documentName = documentName;
        this.useUnsure = useUnsure;
        this.abbrevs = new Dictionary(true);
        for (String s : acronymExpansionsModel.getAcronyms()) {
            this.abbrevs.put(new StringList(s));
        }
        char[] eos = (eosChars + (useNewlineAsEos != null && useNewlineAsEos != false ? "\n" : "") + (useTabAsEos != null && useTabAsEos != false ? "\t" : "")).toCharArray();
        Thread thread = new Thread(() -> {
            try {
                SentenceSampleStream samples = new SentenceSampleStream((ObjectStream)new ObjectStream<String>(){
                    boolean done = false;

                    @Nullable
                    public String read() throws IOException {
                        try {
                            if (this.done) {
                                return null;
                            }
                            String sentenceSample = (String)ONLPSentenceTrainer.this.samplesQueue.take();
                            if (sentenceSample == ONLPSentenceTrainer.POISON) {
                                this.done = true;
                                return null;
                            }
                            return sentenceSample;
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                    }

                    public void reset() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                    }
                });
                SentenceDetectorFactory sentenceDetectorFactory = new SentenceDetectorFactory("en", useTokenEnd != null && useTokenEnd != false, this.abbrevs, eos);
                TrainingParameters params = TrainingParameters.defaultParams();
                logger.info("Training sentence model.");
                this.sentenceModel = SentenceDetectorME.train((String)"en", (ObjectStream)samples, (SentenceDetectorFactory)sentenceDetectorFactory, (TrainingParameters)params);
                logger.info("Finished training sentence model.");
                this.modelTrained.countDown();
            }
            catch (IOException e) {
                this.ioException = e;
            }
        });
        thread.start();
    }

    public void done() {
        this.samplesQueue.add(POISON);
        try {
            this.modelTrained.await();
            if (this.ioException != null) {
                throw new RuntimeException(this.ioException);
            }
            if (this.sentenceModel == null) {
                throw new RuntimeException("Error training sentence model.");
            }
            OutputStream outputStream = Files.newOutputStream(this.outputPath.resolve("sentence.bin"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.sentenceModel.serialize(outputStream);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted before model could be saved.");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write out model.");
        }
    }

    public void process(@Nonnull Artifact artifact) {
        Document document = (Document)artifact.getDocuments().get(this.documentName);
        if (document == null) {
            throw new RuntimeException("No document with name: " + this.documentName);
        }
        String text = document.getText();
        Iterator sentenceIt = document.labelIndex(Sentence.class).iterator();
        if (!sentenceIt.hasNext()) {
            return;
        }
        int prev = 0;
        while (sentenceIt.hasNext()) {
            Sentence sentence = (Sentence)((Object)sentenceIt.next());
            int endIndex = sentence.getEndIndex();
            if (sentence.getSentenceClass() == 1 || this.useUnsure != null && this.useUnsure.booleanValue()) {
                this.samplesQueue.add(text.substring(prev, endIndex));
            }
            prev = endIndex;
        }
    }
}

