/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.BratSentencesWriterKt;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.LabelIndex;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ledu/umn/biomedicus/sentences/BratSentencesWriter;", "Ledu/umn/nlpengine/DocumentTask;", "outputDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class BratSentencesWriter
implements DocumentTask {
    private final Path outputDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Document document) {
        Object object;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String string = document.getArtifactID();
        int n = 0;
        Object[] objectArray2 = objectArray = new Object[1];
        String string2 = "%07d";
        int n2 = Integer.parseInt(string);
        objectArray[n] = n2;
        String documentId = String.format(string2, objectArray2);
        String text = document.getText();
        Path textPath = this.outputDirectory.resolve(documentId + ".txt");
        Path annPath = this.outputDirectory.resolve(documentId + ".ann");
        Files.createDirectories(this.outputDirectory, new FileAttribute[0]);
        File file = textPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"textPath.toFile()");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        FilesKt.writeText((File)file, (String)text, (Charset)charset);
        File file2 = annPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"annPath.toFile()");
        Object object2 = file2;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"StandardCharsets.UTF_8");
        Object object3 = charset2;
        int n3 = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n3);
        object3 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            LabelIndex sentences = document.labelIndex(Sentence.class);
            int i = 1;
            for (Sentence sentence : sentences) {
                CharSequence covered = sentence.coveredText(document.getText());
                StringBuilder builder = new StringBuilder(covered);
                writer.write("" + 'T' + i++ + "\tSentence " + sentence.getStartIndex());
                int offset = 0;
                Sequence $receiver$iv = Regex.findAll$default((Regex)BratSentencesWriterKt.getNewlineTab(), (CharSequence)covered, (int)0, (int)2, null);
                for (Object element$iv : $receiver$iv) {
                    MatchResult it = (MatchResult)element$iv;
                    writer.write("" + ' ' + (sentence.getStartIndex() + it.getRange().getStart()) + ';' + (sentence.getStartIndex() + it.getRange().getLast() + 1));
                    builder.replace(it.getRange().getStart() - offset, it.getRange().getEndInclusive() + 1 - offset, " ");
                    offset += it.getRange().getEndInclusive() - it.getRange().getStart();
                }
                writer.write("" + ' ' + sentence.getEndIndex() + '\t' + builder);
                writer.newLine();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }

    @Inject
    public BratSentencesWriter(@ComponentSetting(value="outputDirectory.asPath") @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }
}

