/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.common.utilities.Patterns;
import edu.umn.biomedicus.sentences.SegmentTextKt;
import edu.umn.biomedicus.sentences.TextSegment;
import edu.umn.biomedicus.structure.Paragraph;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/umn/biomedicus/sentences/SegmentText;", "Ledu/umn/nlpengine/DocumentTask;", "()V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class SegmentText
implements DocumentTask {
    public void run(@NotNull Document document) {
        Span span;
        Object it;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        HashSet<Integer> breaks = new HashSet<Integer>();
        String text = document.getText();
        Object $receiver$iv = document;
        Labeler labeler = $receiver$iv.labeler(TextSegment.class);
        if (!SegmentTextKt.getSingleNewline().containsMatchIn((CharSequence)text)) {
            labeler.add((Label)new TextSegment((TextRange)document));
        }
        $receiver$iv = Regex.findAll$default((Regex)SegmentTextKt.getRegex(), (CharSequence)text, (int)0, (int)2, null);
        Iterator $i$f$labeler = $receiver$iv.iterator();
        while ($i$f$labeler.hasNext()) {
            element$iv = $i$f$labeler.next();
            it = (MatchResult)element$iv;
            breaks.add(it.getRange().getEndInclusive() + 1);
        }
        $receiver$iv = document;
        $receiver$iv = (Iterable)$receiver$iv.labelIndex(Paragraph.class);
        Iterator $i$f$labelIndex = $receiver$iv.iterator();
        while ($i$f$labelIndex.hasNext()) {
            element$iv = $i$f$labelIndex.next();
            it = (Paragraph)((Object)element$iv);
            breaks.add(((Paragraph)((Object)it)).getStartIndex());
        }
        int prev = 0;
        Iterator iterator2 = CollectionsKt.sorted((Iterable)breaks).iterator();
        while (iterator2.hasNext()) {
            int segmentBreak = ((Number)iterator2.next()).intValue();
            if (segmentBreak == prev) continue;
            Span span2 = new Span(prev, segmentBreak);
            if (Patterns.NON_WHITESPACE.matcher(span2.coveredText((CharSequence)text)).find()) {
                labeler.add((Label)new TextSegment((TextRange)span2));
            }
            prev = segmentBreak;
        }
        if (prev != text.length() && Patterns.NON_WHITESPACE.matcher((span = new Span(prev, text.length())).coveredText((CharSequence)text)).find()) {
            labeler.add((Label)new TextSegment((TextRange)span));
        }
    }
}

