/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sentences.TextSegment;
import edu.umn.biomedicus.tokenization.EmbeddingToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.TextRange;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Ledu/umn/biomedicus/sentences/SentenceDeepLearningWriter;", "Ledu/umn/nlpengine/DocumentTask;", "outputDirectory", "", "(Ljava/lang/String;)V", "getOutputDirectory", "()Ljava/lang/String;", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class SentenceDeepLearningWriter
implements DocumentTask {
    @NotNull
    private final String outputDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Document document) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String artifactID = document.getArtifactID();
        String nameWithoutExtension = FilesKt.getNameWithoutExtension((File)new File(artifactID));
        String text = document.getText();
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        FilesKt.writeText$default((File)FilesKt.resolve((File)new File(this.outputDirectory), (String)(nameWithoutExtension + ".txt")), (String)text, null, (int)2, null);
        Document $receiver$iv = document;
        LabelIndex segments = $receiver$iv.labelIndex(TextSegment.class);
        Document $receiver$iv2 = document;
        LabelIndex sentences = $receiver$iv2.labelIndex(Sentence.class);
        Document $receiver$iv3 = document;
        LabelIndex tokens = $receiver$iv3.labelIndex(EmbeddingToken.class);
        Object object2 = FilesKt.resolve((File)new File(this.outputDirectory), (String)(nameWithoutExtension + ".labels"));
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object3 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            for (EmbeddingToken token : tokens) {
                char c;
                Sentence sentence;
                if ((Sentence)sentences.containing((TextRange)token).first() == null) {
                    continue;
                }
                if (sentence.getSentenceClass() == 0) {
                    c = 'O';
                } else {
                    EmbeddingToken embeddingToken = (EmbeddingToken)CollectionsKt.firstOrNull((Iterable)((Iterable)tokens.inside((TextRange)sentence)));
                    c = (embeddingToken != null ? embeddingToken.locationEquals(token) : false) ? (char)'B' : 'I';
                }
                char type = c;
                int isIdentifier = Intrinsics.areEqual((Object)"IDENTIFIER", (Object)token.getText()) ? 1 : 0;
                CharSequence coveredText = token.coveredText(text);
                int startIndex = token.getStartIndex();
                int endIndex = token.getEndIndex();
                Appendable appendable = writer;
                CharSequence charSequence = "0 " + startIndex + ' ' + endIndex + ' ' + type + ' ' + isIdentifier + ' ' + coveredText;
                Appendable appendable2 = appendable.append(charSequence);
                Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
                StringsKt.appendln((Appendable)appendable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }

    @NotNull
    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Inject
    public SentenceDeepLearningWriter(@ComponentSetting(value="outputDirectory") @NotNull String outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }
}

