/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.LabelIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u0011\u0010\u001a\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\bR\u001a\u0010\u001f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0006\"\u0004\b!\u0010\bR\u0011\u0010\"\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\fR\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\b\u00a8\u0006."}, d2={"Ledu/umn/biomedicus/sentences/SentenceEndingStats;", "Ledu/umn/nlpengine/DocumentsProcessor;", "()V", "colon", "", "getColon", "()I", "setColon", "(I)V", "colonRegex", "Lkotlin/text/Regex;", "getColonRegex", "()Lkotlin/text/Regex;", "exRegex", "getExRegex", "exclams", "getExclams", "setExclams", "none", "getNone", "setNone", "periodRegex", "getPeriodRegex", "periods", "getPeriods", "setPeriods", "questRegex", "getQuestRegex", "questions", "getQuestions", "setQuestions", "quote", "getQuote", "setQuote", "quoteRegex", "getQuoteRegex", "semiRegex", "getSemiRegex", "semicolon", "getSemicolon", "setSemicolon", "done", "", "process", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class SentenceEndingStats
implements DocumentsProcessor {
    @NotNull
    private final Regex periodRegex = new Regex("[.]\\s*$");
    @NotNull
    private final Regex exRegex = new Regex("[!]\\s*$");
    @NotNull
    private final Regex questRegex = new Regex("[?]\\s*$");
    @NotNull
    private final Regex semiRegex = new Regex("[;]\\s*$");
    @NotNull
    private final Regex colonRegex = new Regex("[:]\\s*$");
    @NotNull
    private final Regex quoteRegex = new Regex("[.!?;:][\"\u201d]\\s*$");
    private int periods;
    private int exclams;
    private int questions;
    private int semicolon;
    private int colon;
    private int quote;
    private int none;

    @NotNull
    public final Regex getPeriodRegex() {
        return this.periodRegex;
    }

    @NotNull
    public final Regex getExRegex() {
        return this.exRegex;
    }

    @NotNull
    public final Regex getQuestRegex() {
        return this.questRegex;
    }

    @NotNull
    public final Regex getSemiRegex() {
        return this.semiRegex;
    }

    @NotNull
    public final Regex getColonRegex() {
        return this.colonRegex;
    }

    @NotNull
    public final Regex getQuoteRegex() {
        return this.quoteRegex;
    }

    public final int getPeriods() {
        return this.periods;
    }

    public final void setPeriods(int n) {
        this.periods = n;
    }

    public final int getExclams() {
        return this.exclams;
    }

    public final void setExclams(int n) {
        this.exclams = n;
    }

    public final int getQuestions() {
        return this.questions;
    }

    public final void setQuestions(int n) {
        this.questions = n;
    }

    public final int getSemicolon() {
        return this.semicolon;
    }

    public final void setSemicolon(int n) {
        this.semicolon = n;
    }

    public final int getColon() {
        return this.colon;
    }

    public final void setColon(int n) {
        this.colon = n;
    }

    public final int getQuote() {
        return this.quote;
    }

    public final void setQuote(int n) {
        this.quote = n;
    }

    public final int getNone() {
        return this.none;
    }

    public final void setNone(int n) {
        this.none = n;
    }

    public void process(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex sentences = $receiver$iv.labelIndex(Sentence.class);
        for (Sentence sentence : sentences) {
            int n;
            if (sentence.getSentenceClass() == 0) continue;
            CharSequence text = sentence.coveredText(document.getText());
            if (this.periodRegex.containsMatchIn(text)) {
                n = this.periods;
                this.periods = n + 1;
                continue;
            }
            if (this.exRegex.containsMatchIn(text)) {
                n = this.exclams;
                this.exclams = n + 1;
                continue;
            }
            if (this.questRegex.containsMatchIn(text)) {
                n = this.questions;
                this.questions = n + 1;
                continue;
            }
            if (this.semiRegex.containsMatchIn(text)) {
                n = this.semicolon;
                this.semicolon = n + 1;
                continue;
            }
            if (this.colonRegex.containsMatchIn(text)) {
                n = this.colon;
                this.colon = n + 1;
                continue;
            }
            if (this.quoteRegex.containsMatchIn(text)) {
                n = this.quote;
                this.quote = n + 1;
                continue;
            }
            n = this.none;
            this.none = n + 1;
        }
    }

    public void done() {
        String string = "periods: " + this.periods;
        System.out.println((Object)string);
        string = "exclams: " + this.exclams;
        System.out.println((Object)string);
        string = "questions: " + this.questions;
        System.out.println((Object)string);
        string = "semicolon: " + this.semicolon;
        System.out.println((Object)string);
        string = "colon: " + this.colon;
        System.out.println((Object)string);
        string = "quote: " + this.quote;
        System.out.println((Object)string);
        string = "none: " + this.none;
        System.out.println((Object)string);
    }
}

