/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.ExtensionsKt;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sentences.SentencesEvaluationWriter;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactTask;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.LabelIndex;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ledu/umn/biomedicus/sentences/SentencesEvaluator;", "Ledu/umn/nlpengine/ArtifactTask;", "evaluatedDocumentName", "", "goldDocumentName", "sentencesEvaluationWriter", "Ledu/umn/biomedicus/sentences/SentencesEvaluationWriter;", "(Ljava/lang/String;Ljava/lang/String;Ledu/umn/biomedicus/sentences/SentencesEvaluationWriter;)V", "run", "", "artifact", "Ledu/umn/nlpengine/Artifact;", "biomedicus-core"})
public final class SentencesEvaluator
implements ArtifactTask {
    private final String evaluatedDocumentName;
    private final String goldDocumentName;
    private final SentencesEvaluationWriter sentencesEvaluationWriter;

    public void run(@NotNull Artifact artifact) {
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Document document = (Document)artifact.getDocuments().get(this.goldDocumentName);
        if (document == null) {
            String string = "No gold document: " + this.goldDocumentName;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Document goldDocument = document;
        Document document2 = (Document)artifact.getDocuments().get(this.evaluatedDocumentName);
        if (document2 == null) {
            String string = "No evaluated document: " + this.evaluatedDocumentName;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Document evaluatedDocument = document2;
        int hits = 0;
        int misses = 0;
        LabelIndex<Sentence> evaluatedSentences = ExtensionsKt.sentences(evaluatedDocument);
        for (Sentence sentence : ExtensionsKt.sentences(goldDocument)) {
            if (sentence.getSentenceClass() == 0) continue;
            if (evaluatedSentences.contains((Object)sentence)) {
                ++hits;
                continue;
            }
            ++misses;
        }
        this.sentencesEvaluationWriter.write("" + hits + ' ' + misses + '\n');
    }

    @Inject
    public SentencesEvaluator(@ComponentSetting(value="evaluatedDocument") @NotNull String evaluatedDocumentName, @ComponentSetting(value="goldDocument") @NotNull String goldDocumentName, @NotNull SentencesEvaluationWriter sentencesEvaluationWriter) {
        Intrinsics.checkParameterIsNotNull((Object)evaluatedDocumentName, (String)"evaluatedDocumentName");
        Intrinsics.checkParameterIsNotNull((Object)goldDocumentName, (String)"goldDocumentName");
        Intrinsics.checkParameterIsNotNull((Object)sentencesEvaluationWriter, (String)"sentencesEvaluationWriter");
        this.evaluatedDocumentName = evaluatedDocumentName;
        this.goldDocumentName = goldDocumentName;
        this.sentencesEvaluationWriter = sentencesEvaluationWriter;
    }
}

