/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sentences;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sentences.TextSegment;
import edu.umn.biomedicus.tokenization.TokenCandidate;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.TextRange;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ledu/umn/biomedicus/sentences/SentencesWekaWriter;", "Ledu/umn/nlpengine/DocumentsProcessor;", "outputFile", "", "(Ljava/lang/String;)V", "outputWriter", "Ljava/io/BufferedWriter;", "done", "", "escape", "string", "process", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class SentencesWekaWriter
implements DocumentsProcessor {
    private final BufferedWriter outputWriter;

    public void process(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String artifactID = document.getArtifactID();
        String nameWithoutExtension = FilesKt.getNameWithoutExtension((File)new File(artifactID));
        String text = document.getText();
        Document $receiver$iv = document;
        LabelIndex sentences = $receiver$iv.labelIndex(Sentence.class);
        Document $receiver$iv2 = document;
        LabelIndex tokens = $receiver$iv2.labelIndex(TokenCandidate.class);
        Iterator sentenceIt = sentences.iterator();
        Sentence sentence = sentenceIt.hasNext() ? (Sentence)((Object)sentenceIt.next()) : null;
        Document $receiver$iv3 = document;
        for (TextSegment textSegment : $receiver$iv3.labelIndex(TextSegment.class)) {
            for (TokenCandidate token : tokens.inside((TextRange)textSegment)) {
                Sentence sentence2;
                Object it;
                Object object;
                Object object2;
                TokenCandidate tokenCandidate = (TokenCandidate)tokens.backwardFrom((TextRange)token).first();
                int prevEnd = tokenCandidate != null ? tokenCandidate.getEndIndex() : 0;
                TokenCandidate tokenCandidate2 = (TokenCandidate)tokens.forwardFrom((TextRange)token).first();
                int nextBegin = tokenCandidate2 != null ? tokenCandidate2.getStartIndex() : text.length();
                Sentence sentence3 = sentence;
                if (sentence3 != null) {
                    if (!sentence3.contains((TextRange)token)) {
                        Sentence sentence4 = sentence = sentenceIt.hasNext() ? (Sentence)((Object)sentenceIt.next()) : null;
                    }
                }
                if (sentence == null) continue;
                char type = sentence.getSentenceClass() == 0 ? (char)'O' : (Intrinsics.areEqual((Object)(object2 = token), (Object)(object = (TokenCandidate)tokens.inside((TextRange)(it = (sentence2 = sentence))).first())) ? (char)'B' : 'I');
                it = text;
                int $i$a$1$let22 = token.getStartIndex();
                object2 = this;
                Object object3 = it;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)object3).substring(prevEnd, $i$a$1$let22);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = string;
                String pre = super.escape((String)object);
                String $i$a$1$let22 = text;
                int n = token.getStartIndex();
                int n2 = token.getEndIndex();
                object2 = this;
                String string2 = $i$a$1$let22;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = string3;
                String word = super.escape((String)object);
                Object object4 = text;
                n2 = token.getEndIndex();
                object2 = this;
                String string4 = object4;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2, nextBegin);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = string5;
                String post = super.escape((String)object);
                object4 = this.outputWriter;
                CharSequence charSequence = pre + ',' + word + ',' + post + ',' + type;
                Appendable appendable = object4.append(charSequence);
                Intrinsics.checkExpressionValueIsNotNull((Object)appendable, (String)"append(value)");
                StringsKt.appendln((Appendable)appendable);
            }
        }
    }

    private final String escape(String string) {
        return '\'' + StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"'", (String)"\\'", (boolean)false, (int)4, null) + '\'';
    }

    public void done() {
        this.outputWriter.close();
    }

    @Inject
    public SentencesWekaWriter(@ComponentSetting(value="outputFile") @NotNull String outputFile) {
        BufferedWriter bufferedWriter;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Object object2 = new File(outputFile);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Object object3 = charset;
        SentencesWekaWriter sentencesWekaWriter = this;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        sentencesWekaWriter.outputWriter = bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object2 = this.outputWriter;
        object3 = "@relation Token";
        Appendable appendable = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable, (String)"append(value)");
        object2 = StringsKt.appendln((Appendable)StringsKt.appendln((Appendable)appendable));
        object3 = "@attribute preword string";
        Appendable appendable2 = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        object2 = StringsKt.appendln((Appendable)appendable2);
        object3 = "@attribute word string";
        Appendable appendable3 = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable3, (String)"append(value)");
        object2 = StringsKt.appendln((Appendable)appendable3);
        object3 = "@attribute postword string";
        Appendable appendable4 = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable4, (String)"append(value)");
        object2 = StringsKt.appendln((Appendable)appendable4);
        object3 = "@attribute class {B,I,O}";
        Appendable appendable5 = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable5, (String)"append(value)");
        object2 = StringsKt.appendln((Appendable)StringsKt.appendln((Appendable)appendable5));
        object3 = "@data";
        Appendable appendable6 = object2.append((CharSequence)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable6, (String)"append(value)");
        StringsKt.appendln((Appendable)appendable6);
    }
}

