/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.serialization;

import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.common.dictionary.StringsBag;
import edu.umn.biomedicus.common.tuples.PosCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.types.syntax.PartsOfSpeech;
import edu.umn.biomedicus.concepts.CUI;
import edu.umn.biomedicus.concepts.SUI;
import edu.umn.biomedicus.concepts.TUI;
import java.util.Arrays;
import java.util.Collection;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlSerialization {
    private YamlSerialization() {
        throw new UnsupportedOperationException();
    }

    public static Yaml createYaml() {
        return YamlSerialization.createYaml(null);
    }

    public static Yaml createYaml(BidirectionalDictionary bidirectionalDictionary) {
        Yaml yaml = new Yaml((BaseConstructor)YamlSerialization.constructor(bidirectionalDictionary), YamlSerialization.representer(bidirectionalDictionary));
        yaml.addImplicitResolver(new Tag("!cui"), CUI.CUI_PATTERN, "C");
        yaml.addImplicitResolver(new Tag("!tui"), TUI.TUI_PATTERN, "T");
        yaml.addImplicitResolver(new Tag("!sui"), SUI.SUI_PATTERN, "S");
        return yaml;
    }

    private static Constructor constructor(final BidirectionalDictionary bidirectionalDictionary) {
        return new Constructor(){
            {
                this.yamlConstructors.put(new Tag("!pc"), new AbstractConstruct(){

                    public Object construct(Node node) {
                        String value = this.constructScalar((ScalarNode)node);
                        boolean isCapitalized = value.charAt(0) == 'C';
                        PartOfSpeech partOfSpeech = PartsOfSpeech.forTag(value.substring(1));
                        return PosCap.create(partOfSpeech, isCapitalized);
                    }
                });
                this.yamlConstructors.put(new Tag("!pos"), new AbstractConstruct(){

                    public Object construct(Node node) {
                        String value = this.constructScalar((ScalarNode)node);
                        return PartsOfSpeech.forTag(value);
                    }
                });
                this.yamlConstructors.put(new Tag("!cui"), new AbstractConstruct(){

                    public Object construct(Node node) {
                        String val = this.constructScalar((ScalarNode)node);
                        return new CUI(val);
                    }
                });
                this.yamlConstructors.put(new Tag("!tui"), new AbstractConstruct(){

                    public Object construct(Node node) {
                        String val = this.constructScalar((ScalarNode)node);
                        return new TUI(val);
                    }
                });
                this.yamlConstructors.put(new Tag("!sui"), new AbstractConstruct(){

                    public Object construct(Node node) {
                        String val = this.constructScalar((ScalarNode)node);
                        return new SUI(val);
                    }
                });
                if (bidirectionalDictionary != null) {
                    this.yamlConstructors.put(new Tag("!t"), new AbstractConstruct(){

                        public Object construct(Node node) {
                            String val = this.constructScalar((ScalarNode)node);
                            return bidirectionalDictionary.getTermIdentifier(val);
                        }
                    });
                    this.yamlConstructors.put(new Tag("!tv"), new AbstractConstruct(){

                        public Object construct(Node node) {
                            String[] val = (String[])this.constructArray((SequenceNode)node);
                            return bidirectionalDictionary.getTermsBag(Arrays.asList(val));
                        }
                    });
                }
            }
        };
    }

    private static Representer representer(final BidirectionalDictionary bidirectionalDictionary) {
        return new Representer(){
            {
                this.representers.put(PosCap.class, o -> {
                    PosCap posCap = (PosCap)o;
                    String value = (posCap.isCapitalized() ? "C" : Character.valueOf('l')) + posCap.getPartOfSpeech().toString();
                    return this.representScalar(new Tag("!pc"), value);
                });
                this.representers.put(PartOfSpeech.class, o -> {
                    PartOfSpeech partOfSpeech = (PartOfSpeech)((Object)((Object)o));
                    String value = partOfSpeech.toString();
                    return this.representScalar(new Tag("!pos"), value);
                });
                this.representers.put(CUI.class, o -> {
                    CUI cui = (CUI)o;
                    String value = cui.toString();
                    return this.representScalar(new Tag("!cui"), value);
                });
                this.representers.put(TUI.class, o -> {
                    TUI tui = (TUI)o;
                    String value = tui.toString();
                    return this.representScalar(new Tag("!tui"), value);
                });
                this.representers.put(SUI.class, o -> {
                    SUI sui = (SUI)o;
                    String value = sui.toString();
                    return this.representScalar(new Tag("!sui"), value);
                });
                if (bidirectionalDictionary != null) {
                    this.representers.put(StringIdentifier.class, o -> {
                        StringIdentifier it = (StringIdentifier)o;
                        String value = bidirectionalDictionary.getTerm(it);
                        return this.representScalar(new Tag("!t"), value);
                    });
                    this.representers.put(StringsBag.class, o -> {
                        StringsBag tv = (StringsBag)o;
                        Collection<String> expanded = bidirectionalDictionary.getTerms(tv);
                        return this.representSequence(new Tag("!tv"), expanded, null);
                    });
                }
            }
        };
    }
}

