/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sh;

import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.SequenceDetector;
import edu.umn.biomedicus.sh.SocialHistoryKt;
import edu.umn.biomedicus.tokenization.Token;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B9\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u0018"}, d2={"Ledu/umn/biomedicus/sh/CandidateDetectionRules;", "", "alcoholCuePath", "Ljava/nio/file/Path;", "alcoholIgnorePath", "nonalcoholicDrinksPath", "drugCuePath", "nicotineCuePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "alcoholCueDetector", "Ledu/umn/biomedicus/common/SequenceDetector;", "", "Ledu/umn/biomedicus/tokenization/Token;", "getAlcoholCueDetector", "()Ledu/umn/biomedicus/common/SequenceDetector;", "alcoholIgnoreDetector", "getAlcoholIgnoreDetector", "drugCueDetector", "getDrugCueDetector", "nicotineCueDetector", "getNicotineCueDetector", "nonalcoholicDrinksDetector", "getNonalcoholicDrinksDetector", "Companion", "biomedicus-core"})
public final class CandidateDetectionRules {
    @NotNull
    private final SequenceDetector<String, Token> alcoholCueDetector;
    @NotNull
    private final SequenceDetector<String, Token> nonalcoholicDrinksDetector;
    @NotNull
    private final SequenceDetector<String, Token> alcoholIgnoreDetector;
    @NotNull
    private final SequenceDetector<String, Token> drugCueDetector;
    @NotNull
    private final SequenceDetector<String, Token> nicotineCueDetector;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final SequenceDetector<String, Token> getAlcoholCueDetector() {
        return this.alcoholCueDetector;
    }

    @NotNull
    public final SequenceDetector<String, Token> getNonalcoholicDrinksDetector() {
        return this.nonalcoholicDrinksDetector;
    }

    @NotNull
    public final SequenceDetector<String, Token> getAlcoholIgnoreDetector() {
        return this.alcoholIgnoreDetector;
    }

    @NotNull
    public final SequenceDetector<String, Token> getDrugCueDetector() {
        return this.drugCueDetector;
    }

    @NotNull
    public final SequenceDetector<String, Token> getNicotineCueDetector() {
        return this.nicotineCueDetector;
    }

    @Inject
    public CandidateDetectionRules(@Setting(value="sh.alcohol.candidateCues.asDataPath") @NotNull Path alcoholCuePath, @Setting(value="sh.alcohol.cueIgnore.asDataPath") @NotNull Path alcoholIgnorePath, @Setting(value="sh.alcohol.nonalcoholicDrinks.asDataPath") @NotNull Path nonalcoholicDrinksPath, @Setting(value="sh.drugs.candidateCues.asDataPath") @NotNull Path drugCuePath, @Setting(value="sh.nicotine.candidateCues.asDataPath") @NotNull Path nicotineCuePath) {
        Intrinsics.checkParameterIsNotNull((Object)alcoholCuePath, (String)"alcoholCuePath");
        Intrinsics.checkParameterIsNotNull((Object)alcoholIgnorePath, (String)"alcoholIgnorePath");
        Intrinsics.checkParameterIsNotNull((Object)nonalcoholicDrinksPath, (String)"nonalcoholicDrinksPath");
        Intrinsics.checkParameterIsNotNull((Object)drugCuePath, (String)"drugCuePath");
        Intrinsics.checkParameterIsNotNull((Object)nicotineCuePath, (String)"nicotineCuePath");
        log.info("Loading social history candidate detection rule set.");
        this.alcoholCueDetector = SequenceDetector.Factory.loadFromFile(alcoholCuePath, SocialHistoryKt.getTokenStartsWith());
        this.alcoholIgnoreDetector = SequenceDetector.Factory.loadFromFile(alcoholIgnorePath, SocialHistoryKt.getTokenStartsWith());
        this.nonalcoholicDrinksDetector = SequenceDetector.Factory.loadFromFile(nonalcoholicDrinksPath, SocialHistoryKt.getTokenStartsWith());
        this.drugCueDetector = SequenceDetector.Factory.loadFromFile(drugCuePath, SocialHistoryKt.getTokenStartsWith());
        this.nicotineCueDetector = SequenceDetector.Factory.loadFromFile(nicotineCuePath, SocialHistoryKt.getTokenStartsWith());
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(CandidateDetectionRules.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ledu/umn/biomedicus/sh/CandidateDetectionRules$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "biomedicus-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

