/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sh;

import edu.umn.biomedicus.common.SequenceDetector;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.family.Relative;
import edu.umn.biomedicus.sections.Section;
import edu.umn.biomedicus.sections.SectionContent;
import edu.umn.biomedicus.sections.SectionHeader;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sh.AlcoholCandidate;
import edu.umn.biomedicus.sh.AlcoholCue;
import edu.umn.biomedicus.sh.CandidateDetectionRules;
import edu.umn.biomedicus.sh.DrugCandidate;
import edu.umn.biomedicus.sh.DrugCue;
import edu.umn.biomedicus.sh.NicotineCandidate;
import edu.umn.biomedicus.sh.NicotineCue;
import edu.umn.biomedicus.sh.SocialHistoryKt;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Bi\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ledu/umn/biomedicus/sh/SocialHistoryCandidateDetector;", "Ledu/umn/nlpengine/DocumentTask;", "candidateDetectionRules", "Ledu/umn/biomedicus/sh/CandidateDetectionRules;", "(Ledu/umn/biomedicus/sh/CandidateDetectionRules;)V", "alcoholDetector", "Ledu/umn/biomedicus/common/SequenceDetector;", "", "Ledu/umn/biomedicus/tokenization/Token;", "nonalcoholicDetector", "alcoholIgnoreDetector", "drugDetector", "nicotineDetector", "(Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;Ledu/umn/biomedicus/common/SequenceDetector;)V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class SocialHistoryCandidateDetector
implements DocumentTask {
    private final SequenceDetector<String, Token> alcoholDetector;
    private final SequenceDetector<String, Token> nonalcoholicDetector;
    private final SequenceDetector<String, Token> alcoholIgnoreDetector;
    private final SequenceDetector<String, Token> drugDetector;
    private final SequenceDetector<String, Token> nicotineDetector;

    public void run(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex sections = $receiver$iv.labelIndex(Section.class);
        Document $receiver$iv2 = document;
        LabelIndex sectionContents = $receiver$iv2.labelIndex(SectionContent.class);
        Document $receiver$iv3 = document;
        LabelIndex sentences = $receiver$iv3.labelIndex(Sentence.class);
        Document $receiver$iv4 = document;
        LabelIndex tokens = $receiver$iv4.labelIndex(ParseToken.class);
        Document $receiver$iv5 = document;
        LabelIndex relatives = $receiver$iv5.labelIndex(Relative.class);
        Document $receiver$iv6 = document;
        Labeler alcoholCandidateLabeler = $receiver$iv6.labeler(AlcoholCandidate.class);
        Document $receiver$iv7 = document;
        Labeler alcoholCueLabeler = $receiver$iv7.labeler(AlcoholCue.class);
        Document $receiver$iv8 = document;
        Labeler drugCandidateLabeler = $receiver$iv8.labeler(DrugCandidate.class);
        Document $receiver$iv9 = document;
        Labeler drugCueLabeler = $receiver$iv9.labeler(DrugCue.class);
        Document $receiver$iv10 = document;
        Labeler nicotineCandidateLabeler = $receiver$iv10.labeler(NicotineCandidate.class);
        Document $receiver$iv11 = document;
        Labeler nicotineCueLabeler = $receiver$iv11.labeler(NicotineCue.class);
        $receiver$iv11 = document;
        $receiver$iv11 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)$receiver$iv11.labelIndex(SectionHeader.class))), (Function1)((Function1)new Function1<SectionHeader, Boolean>(tokens){
            final /* synthetic */ LabelIndex $tokens;

            public final boolean invoke(@NotNull SectionHeader it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                List headerTokens = this.$tokens.inside((TextRange)it).asList();
                return SocialHistoryKt.getHeaders().matches(headerTokens) != null || SocialHistoryKt.getHeadersExact().matches(headerTokens) != null;
            }
            {
                this.$tokens = labelIndex;
                super(1);
            }
        }));
        for (Object element$iv : $receiver$iv11) {
            Object it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv12;
            SectionContent contents;
            Section section;
            SectionHeader it2 = (SectionHeader)((Object)element$iv);
            if ((Section)sections.containing((TextRange)it2).first() == null) {
                continue;
            }
            if ((SectionContent)sectionContents.inside((TextRange)section).first() == null) {
                throw (Throwable)new BiomedicusException("No contents for section: " + (Object)((Object)section), new String[0]);
            }
            Iterable iterable = (Iterable)sentences.inside((TextRange)contents);
            Iterator iterator2 = $receiver$iv12;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Sentence)((Object)element$iv$iv);
                if (!(document.getText().charAt(it.getEndIndex() - 1) != ':')) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv12 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv12;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Sentence)((Object)element$iv$iv);
                if (!relatives.inside((TextRange)it).isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv12 = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv12) {
                Collection<IntRange> matches;
                Collection<IntRange> drugMatches;
                Collection<IntRange> nonalcoholicMatches;
                Collection<IntRange> alcoholMatches;
                Sentence sentence = (Sentence)((Object)element$iv2);
                List sentenceTokens = tokens.inside((TextRange)sentence).asList();
                it = this.alcoholDetector.detectAll(sentenceTokens);
                Object it3 = it;
                Sentence $i$f$filterTo = it3;
                Object object = !$i$f$filterTo.isEmpty() ? it : null;
                if (object != null) {
                    Collection<IntRange> alcoholIgnores;
                    Collection<IntRange> collection;
                    it = object;
                    alcoholMatches = it;
                    nonalcoholicMatches = this.nonalcoholicDetector.detectAll(sentenceTokens);
                    Collection<IntRange> $i$a$1$takeIf = nonalcoholicMatches;
                    if (!(!$i$a$1$takeIf.isEmpty()) && !(!(collection = (alcoholIgnores = this.alcoholIgnoreDetector.detectAll(sentenceTokens))).isEmpty())) {
                        alcoholCandidateLabeler.add((Label)new AlcoholCandidate((TextRange)sentence));
                        for (IntRange match : alcoholMatches) {
                            alcoholCueLabeler.add((Label)new AlcoholCue(((ParseToken)sentenceTokens.get(match.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(match.getLast())).getEndIndex()));
                        }
                    }
                }
                if (!(alcoholMatches = (drugMatches = this.drugDetector.detectAll(sentenceTokens))).isEmpty()) {
                    drugCandidateLabeler.add((Label)new DrugCandidate((TextRange)sentence));
                    nonalcoholicMatches = drugMatches.iterator();
                    while (nonalcoholicMatches.hasNext()) {
                        IntRange match = (IntRange)nonalcoholicMatches.next();
                        drugCueLabeler.add((Label)new DrugCue(((ParseToken)sentenceTokens.get(match.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(match.getLast())).getEndIndex()));
                    }
                }
                if (!(!(nonalcoholicMatches = (matches = this.nicotineDetector.detectAll(sentenceTokens))).isEmpty())) continue;
                nicotineCandidateLabeler.add((Label)new NicotineCandidate((TextRange)sentence));
                for (IntRange match : matches) {
                    nicotineCueLabeler.add((Label)new NicotineCue(((ParseToken)sentenceTokens.get(match.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(match.getLast())).getEndIndex()));
                }
            }
        }
    }

    public SocialHistoryCandidateDetector(@NotNull SequenceDetector<String, Token> alcoholDetector, @NotNull SequenceDetector<String, Token> nonalcoholicDetector, @NotNull SequenceDetector<String, Token> alcoholIgnoreDetector, @NotNull SequenceDetector<String, Token> drugDetector, @NotNull SequenceDetector<String, Token> nicotineDetector) {
        Intrinsics.checkParameterIsNotNull(alcoholDetector, (String)"alcoholDetector");
        Intrinsics.checkParameterIsNotNull(nonalcoholicDetector, (String)"nonalcoholicDetector");
        Intrinsics.checkParameterIsNotNull(alcoholIgnoreDetector, (String)"alcoholIgnoreDetector");
        Intrinsics.checkParameterIsNotNull(drugDetector, (String)"drugDetector");
        Intrinsics.checkParameterIsNotNull(nicotineDetector, (String)"nicotineDetector");
        this.alcoholDetector = alcoholDetector;
        this.nonalcoholicDetector = nonalcoholicDetector;
        this.alcoholIgnoreDetector = alcoholIgnoreDetector;
        this.drugDetector = drugDetector;
        this.nicotineDetector = nicotineDetector;
    }

    @Inject
    public SocialHistoryCandidateDetector(@NotNull CandidateDetectionRules candidateDetectionRules) {
        Intrinsics.checkParameterIsNotNull((Object)candidateDetectionRules, (String)"candidateDetectionRules");
        this(candidateDetectionRules.getAlcoholCueDetector(), candidateDetectionRules.getNonalcoholicDrinksDetector(), candidateDetectionRules.getAlcoholIgnoreDetector(), candidateDetectionRules.getDrugCueDetector(), candidateDetectionRules.getNicotineCueDetector());
    }
}

