/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.sh;

import edu.umn.biomedicus.common.SequenceDetector;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.sh.AlcoholCandidate;
import edu.umn.biomedicus.sh.DrugCandidate;
import edu.umn.biomedicus.sh.NicotineCandidate;
import edu.umn.biomedicus.sh.UsageStatus;
import edu.umn.biomedicus.sh.UsageStatusPhrases;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ledu/umn/biomedicus/sh/UsageStatusDetector;", "Ledu/umn/nlpengine/DocumentTask;", "phrases", "Ledu/umn/biomedicus/sh/UsageStatusPhrases;", "(Ledu/umn/biomedicus/sh/UsageStatusPhrases;)V", "detector", "Ledu/umn/biomedicus/common/SequenceDetector;", "", "Ledu/umn/biomedicus/tokenization/Token;", "(Ledu/umn/biomedicus/common/SequenceDetector;)V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class UsageStatusDetector
implements DocumentTask {
    private final SequenceDetector<String, Token> detector;

    public void run(@NotNull Document document) {
        Sentence it;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex sentences = $receiver$iv.labelIndex(Sentence.class);
        Document $receiver$iv2 = document;
        LabelIndex tokens = $receiver$iv2.labelIndex(ParseToken.class);
        Document $receiver$iv3 = document;
        LabelIndex nicotineCandidates = $receiver$iv3.labelIndex(NicotineCandidate.class);
        Document $receiver$iv4 = document;
        LabelIndex alcoholCandidates = $receiver$iv4.labelIndex(AlcoholCandidate.class);
        Document $receiver$iv5 = document;
        LabelIndex drugCandidates = $receiver$iv5.labelIndex(DrugCandidate.class);
        Object $receiver$iv6 = document;
        Labeler labeler = $receiver$iv6.labeler(UsageStatus.class);
        $receiver$iv6 = (Iterable)sentences;
        Object $i$f$labeler = $receiver$iv6;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            it = (Sentence)((Object)element$iv$iv);
            if (!(nicotineCandidates.containsSpan((TextRange)it) || alcoholCandidates.containsSpan((TextRange)it) || drugCandidates.containsSpan((TextRange)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv6 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv6;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv6, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it = (Sentence)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            List list = tokens.inside((TextRange)it).asList();
            collection.add(list);
        }
        $receiver$iv6 = (List)destination$iv$iv;
        Iterator iterator3 = $receiver$iv6.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            List sentenceTokens = (List)element$iv;
            Iterable $receiver$iv7 = this.detector.detectAll(sentenceTokens);
            for (Object element$iv2 : $receiver$iv7) {
                IntRange it2 = (IntRange)element$iv2;
                labeler.add((Label)new UsageStatus(((ParseToken)sentenceTokens.get(it2.getFirst())).getStartIndex(), ((ParseToken)sentenceTokens.get(it2.getLast())).getEndIndex()));
            }
        }
    }

    public UsageStatusDetector(@NotNull SequenceDetector<String, Token> detector2) {
        Intrinsics.checkParameterIsNotNull(detector2, (String)"detector");
        this.detector = detector2;
    }

    @Inject
    public UsageStatusDetector(@NotNull UsageStatusPhrases phrases) {
        Intrinsics.checkParameterIsNotNull((Object)phrases, (String)"phrases");
        this(phrases.getDetector());
    }
}

