/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.stopwords;

import com.google.inject.Inject;
import edu.umn.biomedicus.stopwords.StopWord;
import edu.umn.biomedicus.stopwords.Stopwords;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import javax.annotation.Nonnull;

public class LabelStopWords
implements DocumentTask {
    private final Stopwords stopwords;

    @Inject
    public LabelStopWords(Stopwords stopwords) {
        this.stopwords = stopwords;
    }

    public void run(@Nonnull Document document) {
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        Labeler stopWordsLabeler = document.labeler(StopWord.class);
        for (ParseToken parseTokenLabel : parseTokenLabelIndex) {
            if (!this.stopwords.isStopWord(parseTokenLabel)) continue;
            stopWordsLabeler.add((Label)new StopWord(parseTokenLabel));
        }
    }
}

