/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.stopwords;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.stopwords.Stopwords;
import edu.umn.biomedicus.tokenization.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProvidedBy(value=Loader.class)
public class StopwordsModel
implements Stopwords {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopwordsModel.class);
    private final Set<String> stopwordsList;

    private StopwordsModel(Set<String> stopwordsList) {
        this.stopwordsList = Collections.unmodifiableSet(Objects.requireNonNull(stopwordsList));
    }

    @Override
    public boolean isStopWord(Token token) {
        String value = token.getText().toLowerCase().trim();
        return this.stopwordsList.contains(value);
    }

    @Singleton
    public static class Loader
    extends DataLoader<StopwordsModel> {
        private final Path stopwordsPath;

        @Inject
        public Loader(@Setting(value="stopwords.fileBased.asDataPath") Path stopwordsPath) {
            this.stopwordsPath = stopwordsPath;
        }

        @Override
        protected StopwordsModel loadModel() throws BiomedicusException {
            LOGGER.info("Building stopwords list from input stream");
            HashSet<String> stopwordsListBuilder = new HashSet<String>();
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.stopwordsPath);){
                String nextLine;
                while ((nextLine = bufferedReader.readLine()) != null) {
                    if (nextLine.isEmpty()) continue;
                    stopwordsListBuilder.add(nextLine.toLowerCase());
                }
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
            return new StopwordsModel(stopwordsListBuilder);
        }
    }
}

