/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.syntaxnet;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.parsing.DependencyParse;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.syntaxnet.Tokens2Conll;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyntaxnetParser
implements DocumentTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyntaxnetParser.class);
    private final Path installationDir;
    private final String modelDirString;

    @Inject
    SyntaxnetParser(@Setting(value="syntaxnet.installationDir.asPath") Path installationDir, @Setting(value="syntaxnet.modelDir") String modelDirString) {
        this.installationDir = installationDir;
        this.modelDirString = modelDirString;
    }

    private static Runnable errorStreamLogger(Process process2) {
        return () -> {
            InputStream errorStream = process2.getErrorStream();
            InputStreamReader inputStreamReader = new InputStreamReader(errorStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.startsWith("F") || line.startsWith("E") || line.startsWith("W")) {
                        LOGGER.error(line);
                        continue;
                    }
                    LOGGER.trace(line);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading error stream.", (Throwable)e);
            }
        };
    }

    public void run(@Nonnull Document document) {
        LabelIndex sentenceLabelIndex = document.labelIndex(Sentence.class);
        LabelIndex tokenLabelIndex = document.labelIndex(ParseToken.class);
        Labeler dependencyParseLabeler = document.labeler(DependencyParse.class);
        Path parserEval = this.installationDir.resolve("bazel-bin/syntaxnet/parser_eval");
        Path modelDir = this.installationDir.resolve(this.modelDirString);
        try {
            Process parser = new ProcessBuilder(new String[0]).directory(this.installationDir.toFile()).command(parserEval.toString(), "--input=stdin-conll", "--output=stdout-conll", "--hidden_layer_sizes=512,512", "--arg_prefix=brain_parser", "--graph_builder=structured", "--task_context=" + modelDir.resolve("context.pbtxt"), "--model_path=" + modelDir.resolve("parser-params"), "--slim_model", "--batch_size=1024").start();
            Process tagger = new ProcessBuilder(new String[0]).directory(this.installationDir.toFile()).command(parserEval.toString(), "--input=stdin-conll", "--output=stdout-conll", "--hidden_layer_sizes=64", "--arg_prefix=brain_tagger", "--graph_builder=structured", "--task_context=" + modelDir.resolve("context.pbtxt"), "--model_path=" + modelDir.resolve("tagger-params"), "--slim_model", "--batch_size=1024").start();
            new Thread(SyntaxnetParser.errorStreamLogger(tagger)).start();
            new Thread(SyntaxnetParser.errorStreamLogger(parser)).start();
            new Thread(() -> {
                try (InputStream inputStream = tagger.getInputStream();
                     OutputStream outputStream = parser.getOutputStream();){
                    int in;
                    while ((in = inputStream.read()) != -1) {
                        outputStream.write(in);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error transferring from input to output.");
                }
            }).start();
            try (OutputStreamWriter writer = new OutputStreamWriter(tagger.getOutputStream());){
                for (Sentence sentence : sentenceLabelIndex) {
                    LabelIndex sentenceTokens = tokenLabelIndex.inside((TextRange)sentence);
                    String conllString = new Tokens2Conll((Collection<ParseToken>)sentenceTokens).conllString();
                    writer.write(conllString);
                    writer.write("\n");
                }
            }
            var10_11 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(parser.getInputStream()));){
                for (Sentence sentence : sentenceLabelIndex) {
                    String line;
                    StringBuilder sentenceParse = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null && !line.isEmpty()) {
                        sentenceParse.append(line).append("\n");
                    }
                }
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
            parser.destroy();
            tagger.destroy();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

