/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.WordCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.tnt.WordCapAdapter;
import edu.umn.biomedicus.tnt.WordCapFilter;
import edu.umn.biomedicus.tnt.WordPosFrequencies;

class FilteredWordPosFrequencies {
    private final WordPosFrequencies wordPosFrequencies;
    private final WordCapFilter filter;
    private final WordCapAdapter wordCapAdapter;

    FilteredWordPosFrequencies(WordPosFrequencies wordPosFrequencies, WordCapFilter filter, WordCapAdapter wordCapAdapter) {
        this.wordPosFrequencies = wordPosFrequencies;
        this.filter = filter;
        this.wordCapAdapter = wordCapAdapter;
    }

    FilteredWordPosFrequencies(WordCapFilter filter, WordCapAdapter wordCapAdapter) {
        this(new WordPosFrequencies(), filter, wordCapAdapter);
    }

    void addWord(WordCap wordCap, PartOfSpeech partOfSpeech) {
        WordCap adapted = this.wordCapAdapter.apply(wordCap);
        if (this.filter.test(adapted)) {
            this.wordPosFrequencies.addCount(adapted.getWord(), partOfSpeech, 1);
        }
    }

    WordCapFilter getFilter() {
        return this.filter;
    }

    WordCapAdapter getWordCapAdapter() {
        return this.wordCapAdapter;
    }

    WordPosFrequencies getWordPosFrequencies() {
        return this.wordPosFrequencies;
    }
}

