/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.common.tuples.WordCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.tnt.DataStoreFactory;
import edu.umn.biomedicus.tnt.KnownWordsDataStore;
import edu.umn.biomedicus.tnt.WordCapAdapter;
import edu.umn.biomedicus.tnt.WordCapFilter;
import edu.umn.biomedicus.tnt.WordPosFrequencies;
import edu.umn.biomedicus.tnt.WordProbabilityModel;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class KnownWordProbabilityModel
implements WordProbabilityModel {
    private int id;
    private WordCapAdapter wordCapAdapter;
    private WordCapFilter filter;
    private transient KnownWordsDataStore knownWordsDataStore;

    @Override
    public double logProbabilityOfWord(PartOfSpeech candidate, WordCap wordCap) {
        WordCap adapted = this.wordCapAdapter.apply(wordCap);
        Double prob = this.knownWordsDataStore.getProbability(adapted.getWord(), candidate);
        if (prob == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return prob;
    }

    @Override
    public Set<PartOfSpeech> getCandidates(WordCap wordCap) {
        WordCap adapted = this.wordCapAdapter.apply(wordCap);
        final List<PartOfSpeech> candidates = this.knownWordsDataStore.getCandidates(adapted.getWord());
        return new AbstractSet<PartOfSpeech>(){

            @Override
            public Iterator<PartOfSpeech> iterator() {
                return candidates.iterator();
            }

            @Override
            public int size() {
                return candidates.size();
            }
        };
    }

    @Override
    public boolean isKnown(WordCap wordCap) {
        WordCap adapted = this.wordCapAdapter.apply(wordCap);
        String word = adapted.getWord();
        return this.knownWordsDataStore.isKnown(word);
    }

    void train(WordPosFrequencies wordPosFrequencies, Set<PartOfSpeech> tagSet) {
        HashMap<Pair<PartOfSpeech, String>, Double> lexicalProbabilities = new HashMap<Pair<PartOfSpeech, String>, Double>();
        for (String word : wordPosFrequencies.getWords()) {
            for (PartOfSpeech partOfSpeech : tagSet) {
                double probability;
                int wordFreq = wordPosFrequencies.frequencyOfWordAndPartOfSpeech(word, partOfSpeech);
                int posFreq = wordPosFrequencies.frequencyOfPartOfSpeech(partOfSpeech);
                if (posFreq == 0 || (probability = Math.log10((double)wordFreq / (double)posFreq)) == Double.NEGATIVE_INFINITY) continue;
                lexicalProbabilities.put(Pair.of(partOfSpeech, word), probability);
            }
        }
        this.knownWordsDataStore.addAllProbabilities(lexicalProbabilities);
    }

    @Override
    public void createDataStore(DataStoreFactory dataStoreFactory) {
        this.knownWordsDataStore = dataStoreFactory.createKnownWordsDataStore(this.id);
    }

    @Override
    public void openDataStore(DataStoreFactory dataStoreFactory) {
        this.knownWordsDataStore = dataStoreFactory.openKnownWordDataStore(this.id);
    }

    @Override
    public void writeData() {
        this.knownWordsDataStore.write();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public WordCapAdapter getWordCapAdapter() {
        return this.wordCapAdapter;
    }

    public void setWordCapAdapter(WordCapAdapter wordCapAdapter) {
        this.wordCapAdapter = wordCapAdapter;
    }

    public WordCapFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WordCapFilter filter) {
        this.filter = filter;
    }
}

