/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.PosCap;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

class PosCapTrigramModel {
    private final double[] unigramProbabilities;
    private final double[][] bigramProbabilities;
    private final double[][][] trigramProbabilities;
    private final double unigramLambda;
    private final double bigramLambda;
    private final double trigramLambda;

    public PosCapTrigramModel(double[] unigramProbabilities, double[][] bigramProbabilities, double[][][] trigramProbabilities, double unigramLambda, double bigramLambda, double trigramLambda) {
        this.unigramProbabilities = unigramProbabilities;
        this.bigramProbabilities = bigramProbabilities;
        this.trigramProbabilities = trigramProbabilities;
        this.unigramLambda = unigramLambda;
        this.bigramLambda = bigramLambda;
        this.trigramLambda = trigramLambda;
    }

    public static PosCapTrigramModel createFromStore(Map<String, Object> store) {
        double[][][] trigrams;
        double[][] bigrams;
        Map unigram = (Map)store.get("unigram");
        double[] unigrams = new double[PosCap.cardinality()];
        Arrays.fill(unigrams, 0.0);
        unigram.entrySet().forEach(e -> {
            unigrams[((PosCap)e.getKey()).ordinal()] = (Double)e.getValue();
        });
        Map bigram = (Map)store.get("bigram");
        for (double[] doubles : bigrams = new double[PosCap.cardinality()][PosCap.cardinality()]) {
            Arrays.fill(doubles, 0.0);
        }
        bigram.entrySet().forEach(e1 -> ((Map)e1.getValue()).entrySet().forEach(e2 -> {
            bigrams[((PosCap)e1.getKey()).ordinal()][((PosCap)e2.getKey()).ordinal()] = (Double)e2.getValue();
        }));
        Map trigram = (Map)store.get("trigram");
        double[][][] dArray = trigrams = new double[PosCap.cardinality()][PosCap.cardinality()][PosCap.cardinality()];
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[][] bigramsInTrigram;
            for (double[] unigramsInTrigram : bigramsInTrigram = dArray[i]) {
                Arrays.fill(unigramsInTrigram, 0.0);
            }
        }
        trigram.entrySet().forEach(e1 -> ((Map)e1.getValue()).entrySet().forEach(e2 -> ((Map)e2.getValue()).entrySet().forEach(e3 -> {
            trigrams[((PosCap)e1.getKey()).ordinal()][((PosCap)e2.getKey()).ordinal()][((PosCap)e3.getKey()).ordinal()] = (Double)e3.getValue();
        })));
        return new PosCapTrigramModel(unigrams, bigrams, trigrams, (Double)store.get("unigramLambda"), (Double)store.get("bigramLambda"), (Double)store.get("trigramLambda"));
    }

    public double getTrigramProbability(PosCap first, PosCap second, PosCap third) {
        double unigramProbability = this.unigramProbabilities[third.ordinal()];
        double bigramProbability = this.bigramProbabilities[second.ordinal()][third.ordinal()];
        double trigramProbability = this.trigramProbabilities[first.ordinal()][second.ordinal()][third.ordinal()];
        return this.unigramLambda * unigramProbability + this.bigramLambda * bigramProbability + this.trigramLambda * trigramProbability;
    }

    public Map<String, Object> createStore() {
        TreeMap<String, Object> store = new TreeMap<String, Object>();
        store.put("unigramLambda", this.unigramLambda);
        store.put("bigramLambda", this.bigramLambda);
        store.put("trigramLambda", this.trigramLambda);
        TreeMap<PosCap, Double> unigrams = new TreeMap<PosCap, Double>();
        for (int i = 0; i < this.unigramProbabilities.length; ++i) {
            if (!(this.unigramProbabilities[i] > 0.0)) continue;
            unigrams.put(PosCap.createFromOrdinal(i), this.unigramProbabilities[i]);
        }
        store.put("unigram", unigrams);
        TreeMap<PosCap, Map> bigrams = new TreeMap<PosCap, Map>();
        for (int i = 0; i < this.bigramProbabilities.length; ++i) {
            for (int j = 0; j < this.bigramProbabilities[i].length; ++j) {
                int second = j;
                if (!(this.bigramProbabilities[i][j] > 0.0)) continue;
                bigrams.compute(PosCap.createFromOrdinal(i), (key, value) -> {
                    if (value == null) {
                        value = new TreeMap<PosCap, Double>();
                    }
                    value.put(PosCap.createFromOrdinal(second), this.bigramProbabilities[key.ordinal()][second]);
                    return value;
                });
            }
        }
        store.put("bigram", bigrams);
        TreeMap<PosCap, Map> trigrams = new TreeMap<PosCap, Map>();
        for (int i = 0; i < this.trigramProbabilities.length; ++i) {
            for (int j = 0; j < this.trigramProbabilities[i].length; ++j) {
                for (int k = 0; k < this.trigramProbabilities[i][j].length; ++k) {
                    if (!(this.trigramProbabilities[i][j][k] > 0.0)) continue;
                    int second = j;
                    int third = k;
                    trigrams.compute(PosCap.createFromOrdinal(i), (key, value) -> {
                        if (value == null) {
                            value = new TreeMap<PosCap, Map>();
                        }
                        value.compute(PosCap.createFromOrdinal(second), (key2, value2) -> {
                            if (value2 == null) {
                                value2 = new TreeMap<PosCap, Double>();
                            }
                            value2.put(PosCap.createFromOrdinal(third), this.trigramProbabilities[key.ordinal()][key2.ordinal()][third]);
                            return value2;
                        });
                        return value;
                    });
                }
            }
        }
        store.put("trigram", trigrams);
        return store;
    }
}

