/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.PosCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tnt.PosCapTrigramModel;
import edu.umn.biomedicus.tokenization.ParseToken;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PosCapTrigramModelTrainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PosCapTrigramModelTrainer.class);
    private static final PosCap BBS_POS_CAP = PosCap.create(PartOfSpeech.BBS, false);
    private static final PosCap BOS_POS_CAP = PosCap.create(PartOfSpeech.BOS, false);
    private static final PosCap EOS_POS_CAP = PosCap.create(PartOfSpeech.EOS, false);
    private final int[] tagFrequencies;
    private final int[][] bigramFrequencies;
    private final int[][][] trigramFrequencies;
    private int taggedTokens;

    public PosCapTrigramModelTrainer(int taggedTokens, int[][][] trigramFrequencies, int[][] bigramFrequencies, int[] tagFrequencies) {
        this.taggedTokens = taggedTokens;
        this.trigramFrequencies = trigramFrequencies;
        this.bigramFrequencies = bigramFrequencies;
        this.tagFrequencies = tagFrequencies;
    }

    public PosCapTrigramModelTrainer() {
        int[][][] object = this.trigramFrequencies = new int[PosCap.cardinality()][PosCap.cardinality()][PosCap.cardinality()];
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            int[][] bigramInTrigrams;
            for (int[] unigramInBigramInTrigrams : bigramInTrigrams = object[i]) {
                Arrays.fill(unigramInBigramInTrigrams, 0);
            }
        }
        for (int[] unigramInBigrams : this.bigramFrequencies = new int[PosCap.cardinality()][PosCap.cardinality()]) {
            Arrays.fill(unigramInBigrams, 0);
        }
        this.tagFrequencies = new int[PosCap.cardinality()];
        Arrays.fill(this.tagFrequencies, 0);
        this.taggedTokens = 0;
    }

    public void addSentence(List<ParseToken> tokens, List<PosTag> partsOfSpeech) {
        int eos;
        int[] tokenPosCaps = new int[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            tokenPosCaps[i] = PosCap.create(partsOfSpeech.get(i).getPartOfSpeech(), Character.isUpperCase(tokens.get(i).getText().charAt(0))).ordinal();
        }
        int[] posCaps = new int[tokenPosCaps.length + 3];
        posCaps[0] = BBS_POS_CAP.ordinal();
        posCaps[1] = BOS_POS_CAP.ordinal();
        System.arraycopy(tokenPosCaps, 0, posCaps, 2, tokenPosCaps.length);
        int length = posCaps.length;
        posCaps[length - 1] = eos = EOS_POS_CAP.ordinal();
        int n = posCaps[0];
        this.tagFrequencies[n] = this.tagFrequencies[n] + 1;
        int n2 = posCaps[1];
        this.tagFrequencies[n2] = this.tagFrequencies[n2] + 1;
        int[] nArray = this.bigramFrequencies[posCaps[0]];
        int n3 = posCaps[1];
        nArray[n3] = nArray[n3] + 1;
        this.taggedTokens += 2;
        for (int i = 0; i < length - 3; ++i) {
            int second = posCaps[i + 1];
            int last = posCaps[i + 2];
            int[] nArray2 = this.trigramFrequencies[posCaps[i]][second];
            int n4 = last;
            nArray2[n4] = nArray2[n4] + 1;
            int[] nArray3 = this.bigramFrequencies[second];
            int n5 = last;
            nArray3[n5] = nArray3[n5] + 1;
            int n6 = last;
            this.tagFrequencies[n6] = this.tagFrequencies[n6] + 1;
            ++this.taggedTokens;
        }
    }

    public PosCapTrigramModel build() {
        LOGGER.info("Building pos cap trigram model");
        LOGGER.debug("Computing unigram probabilities");
        double[] unigramProbabilities = Arrays.stream(this.tagFrequencies).mapToDouble(freq -> (double)freq / (double)this.taggedTokens).toArray();
        LOGGER.debug("Computing bigram probabilities");
        int cardinality = PosCap.cardinality();
        double[][] bigramProbabilities = new double[cardinality][cardinality];
        for (int i = 0; i < bigramProbabilities.length; ++i) {
            for (int j = 0; j < bigramProbabilities[i].length; ++j) {
                int bigramFrequency = this.bigramFrequencies[i][j];
                int unigramFrequency = this.tagFrequencies[i];
                bigramProbabilities[i][j] = unigramFrequency == 0 ? 0.0 : (double)bigramFrequency / (double)unigramFrequency;
            }
        }
        int lambda1 = 0;
        int lambda2 = 0;
        int lambda3 = 0;
        LOGGER.debug("Computing trigram probabilities and smoothing coefficients");
        double[][][] trigramProbabilities = new double[cardinality][cardinality][cardinality];
        for (int i = 0; i < trigramProbabilities.length; ++i) {
            for (int j = 0; j < trigramProbabilities[i].length; ++j) {
                for (int k = 0; k < trigramProbabilities[i][j].length; ++k) {
                    int headBigramFrequency = this.bigramFrequencies[i][j];
                    int trigramFrequency = this.trigramFrequencies[i][j][k];
                    double probability = headBigramFrequency == 0 ? 0.0 : (double)trigramFrequency / (double)headBigramFrequency;
                    trigramProbabilities[i][j][k] = probability;
                    double case1 = (double)(trigramFrequency - 1) / (double)(headBigramFrequency - 1);
                    double case2 = (double)(this.bigramFrequencies[j][k] - 1) / (double)(this.tagFrequencies[j] - 1);
                    double case3 = (double)(this.tagFrequencies[k] - 1) / (double)(this.taggedTokens - 1);
                    if (case1 >= case2 && case1 >= case3) {
                        lambda3 += trigramFrequency;
                        continue;
                    }
                    if (case2 >= case3) {
                        lambda2 += trigramFrequency;
                        continue;
                    }
                    lambda1 += trigramFrequency;
                }
            }
        }
        double sums = lambda1 + lambda2 + lambda3;
        double unigramLambda = (double)lambda1 / sums;
        double bigramLambda = (double)lambda2 / sums;
        double trigramLambda = (double)lambda3 / sums;
        LOGGER.info("Finished build pos cap trigram model");
        return new PosCapTrigramModel(unigramProbabilities, bigramProbabilities, trigramProbabilities, unigramLambda, bigramLambda, trigramLambda);
    }
}

