/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.framework.LifecycleManaged;
import edu.umn.biomedicus.tnt.DataStoreFactory;
import edu.umn.biomedicus.tnt.KnownWordsDataStore;
import edu.umn.biomedicus.tnt.SuffixDataStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class RocksDbDataStoreFactory
implements DataStoreFactory,
LifecycleManaged {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDbDataStoreFactory.class);
    private final Collection<RocksDB> rocksDBS = new ArrayList<RocksDB>();
    private final boolean inMemory;
    private Path dbPath;

    @Inject
    public RocksDbDataStoreFactory(@Setting(value="tnt.word.db.asDataPath") Path dbPath, @Setting(value="tnt.word.inMemory") boolean inMemory) {
        this.dbPath = dbPath;
        this.inMemory = inMemory;
    }

    @Override
    public void setDbPath(Path dbPath) {
        this.dbPath = dbPath;
    }

    @Override
    public SuffixDataStore openSuffixDataStore(int id) {
        RocksDB.loadLibrary();
        try {
            LOGGER.info("Opening TnT suffix model: {}", (Object)id);
            RocksDB rocksDB = RocksDB.openReadOnly((String)this.dbPath.resolve(this.getSuffixesName(id)).toString());
            RocksDbSuffixDataStore rocksDbSuffixDataStore = new RocksDbSuffixDataStore(rocksDB);
            if (this.inMemory) {
                LOGGER.info("Loading TnT suffix model into memory: {}", (Object)id);
                InMemorySuffixDataStore inMemorySuffixDataStore = rocksDbSuffixDataStore.inMemory();
                LOGGER.info("Done loading TnT suffix model into memory: {}", (Object)id);
                rocksDB.close();
                return inMemorySuffixDataStore;
            }
            this.rocksDBS.add(rocksDB);
            return rocksDbSuffixDataStore;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSuffixesName(int id) {
        return "" + id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SuffixDataStore createSuffixDataStore(int id) {
        RocksDB.loadLibrary();
        try (Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();){
            Files.createDirectories(this.dbPath, new FileAttribute[0]);
            RocksDB rocksDB = RocksDB.open((Options)options, (String)this.dbPath.resolve(this.getSuffixesName(id)).toString());
            this.rocksDBS.add(rocksDB);
            RocksDbSuffixDataStore rocksDbSuffixDataStore = new RocksDbSuffixDataStore(rocksDB);
            return rocksDbSuffixDataStore;
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    private String getWordsName(int id) {
        return id + "-words";
    }

    private String getCandidatesName(int id) {
        return id + "-candidates";
    }

    @Override
    public KnownWordsDataStore openKnownWordDataStore(int id) {
        RocksDB.loadLibrary();
        try {
            LOGGER.info("Opening TnT model known word model: {}", (Object)id);
            RocksDB rocksDB = RocksDB.openReadOnly((String)this.dbPath.resolve(this.getWordsName(id)).toString());
            RocksDB candidatesDB = RocksDB.openReadOnly((String)this.dbPath.resolve(this.getCandidatesName(id)).toString());
            RocksDbKnownWordsDataStore rocksDbKnownWordsDataStore = new RocksDbKnownWordsDataStore(rocksDB, candidatesDB);
            if (this.inMemory) {
                LOGGER.info("Loading TnT known word model into memory: {}", (Object)id);
                InMemoryKnownWordDataStore inMemoryKnownWordDataStore = rocksDbKnownWordsDataStore.inMemory();
                LOGGER.info("Done loading TnT known word model into memory: {}", (Object)id);
                rocksDB.close();
                candidatesDB.close();
                return inMemoryKnownWordDataStore;
            }
            this.rocksDBS.add(rocksDB);
            this.rocksDBS.add(candidatesDB);
            return rocksDbKnownWordsDataStore;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KnownWordsDataStore createKnownWordsDataStore(int id) {
        RocksDB.loadLibrary();
        try (Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();){
            Files.createDirectories(this.dbPath, new FileAttribute[0]);
            RocksDB rocksDB = RocksDB.open((Options)options, (String)this.dbPath.resolve(this.getWordsName(id)).toString());
            this.rocksDBS.add(rocksDB);
            RocksDB candidatesDB = RocksDB.open((Options)options, (String)this.dbPath.resolve(this.getCandidatesName(id)).toString());
            this.rocksDBS.add(candidatesDB);
            RocksDbKnownWordsDataStore rocksDbKnownWordsDataStore = new RocksDbKnownWordsDataStore(rocksDB, candidatesDB);
            return rocksDbKnownWordsDataStore;
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doShutdown() {
        for (RocksDB rocksDB : this.rocksDBS) {
            rocksDB.close();
        }
    }

    static byte[] getPosWordBytes(PartOfSpeech candidate, String word) {
        byte[] bytes = word.getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length + 4);
        byteBuffer.putInt(candidate.ordinal()).put(word.getBytes(StandardCharsets.UTF_8));
        return byteBuffer.array();
    }

    static Pair<PartOfSpeech, String> getPosWordFromBytes(@Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        PartOfSpeech partOfSpeech = PartOfSpeech.values()[wrap.getInt()];
        byte[] stringBytes = new byte[wrap.remaining()];
        wrap.get(stringBytes);
        String s = new String(stringBytes, StandardCharsets.UTF_8);
        return Pair.of(partOfSpeech, s);
    }

    static byte[] getPartsOfSpeechBytes(List<PartOfSpeech> partsOfSpeech) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * partsOfSpeech.size());
        for (PartOfSpeech candidate : partsOfSpeech) {
            byteBuffer.putInt(candidate.ordinal());
        }
        return byteBuffer.array();
    }

    static List<PartOfSpeech> getPartsOfSpeechFromBytes(@Nullable byte[] bytes) {
        if (bytes == null) {
            return Collections.emptyList();
        }
        int size = bytes.length / 4;
        ArrayList<PartOfSpeech> partsOfSpeech = new ArrayList<PartOfSpeech>(size);
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        while (wrap.hasRemaining()) {
            PartOfSpeech partOfSpeech = PartOfSpeech.values()[wrap.getInt()];
            partsOfSpeech.add(partOfSpeech);
        }
        return partsOfSpeech;
    }

    private static class RocksDbKnownWordsDataStore
    implements KnownWordsDataStore {
        private final RocksDB probabilitiesDB;
        private final RocksDB candidatesDB;

        public RocksDbKnownWordsDataStore(RocksDB probabilitiesDB, RocksDB candidatesDB) {
            this.probabilitiesDB = probabilitiesDB;
            this.candidatesDB = candidatesDB;
        }

        @Override
        @Nullable
        public Double getProbability(String word, PartOfSpeech candidate) {
            byte[] posWordBytes = RocksDbDataStoreFactory.getPosWordBytes(candidate, word);
            try {
                byte[] bytes = this.probabilitiesDB.get(posWordBytes);
                return bytes == null ? null : Double.valueOf(ByteBuffer.wrap(bytes).getDouble());
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<PartOfSpeech> getCandidates(String word) {
            try {
                return RocksDbDataStoreFactory.getPartsOfSpeechFromBytes(this.candidatesDB.get(word.getBytes(StandardCharsets.UTF_8)));
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isKnown(String word) {
            try {
                return this.candidatesDB.get(word.getBytes(StandardCharsets.UTF_8)) != null;
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void addAllProbabilities(Map<Pair<PartOfSpeech, String>, Double> lexicalProbabilities) {
            TreeMap<String, List> candidates = new TreeMap<String, List>();
            for (Map.Entry<Pair<PartOfSpeech, String>, Double> entry : lexicalProbabilities.entrySet()) {
                PartOfSpeech partOfSpeech = entry.getKey().getFirst();
                String word = entry.getKey().getSecond();
                byte[] posWordBytes = RocksDbDataStoreFactory.getPosWordBytes(partOfSpeech, word);
                try {
                    this.probabilitiesDB.put(posWordBytes, ByteBuffer.allocate(8).putDouble(entry.getValue()).array());
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
                candidates.compute(word, (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<PartOfSpeech>();
                    }
                    v.add(partOfSpeech);
                    return v;
                });
            }
            for (Map.Entry<Pair<PartOfSpeech, String>, Double> entry : candidates.entrySet()) {
                String word = (String)((Object)entry.getKey());
                List parts = (List)((Object)entry.getValue());
                byte[] partsOfSpeechBytes = RocksDbDataStoreFactory.getPartsOfSpeechBytes(parts);
                try {
                    this.candidatesDB.put(word.getBytes(StandardCharsets.UTF_8), partsOfSpeechBytes);
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        InMemoryKnownWordDataStore inMemory() {
            InMemoryKnownWordDataStore inMemory = new InMemoryKnownWordDataStore();
            try (RocksIterator rocksIterator = this.probabilitiesDB.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    Pair<PartOfSpeech, String> posWord = RocksDbDataStoreFactory.getPosWordFromBytes(rocksIterator.key());
                    double prob = ByteBuffer.wrap(rocksIterator.value()).getDouble();
                    inMemory.addProbability(posWord.getSecond(), posWord.getFirst(), prob);
                    rocksIterator.next();
                }
            }
            return inMemory;
        }

        @Override
        public void write() {
        }
    }

    private static class RocksDbSuffixDataStore
    implements SuffixDataStore {
        private final RocksDB probabilitiesDB;

        public RocksDbSuffixDataStore(RocksDB probabilitiesDB) {
            this.probabilitiesDB = probabilitiesDB;
        }

        @Override
        @Nullable
        public Double getProbability(String suffix, PartOfSpeech candidate) {
            try {
                byte[] bytes = this.probabilitiesDB.get(RocksDbDataStoreFactory.getPosWordBytes(candidate, suffix));
                return bytes == null ? null : Double.valueOf(ByteBuffer.wrap(bytes).getDouble());
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void addAllProbabilities(TreeMap<Pair<PartOfSpeech, String>, Double> probabilities) {
            for (Map.Entry<Pair<PartOfSpeech, String>, Double> entry : probabilities.entrySet()) {
                PartOfSpeech partOfSpeech = entry.getKey().getFirst();
                String word = entry.getKey().getSecond();
                byte[] posWordBytes = RocksDbDataStoreFactory.getPosWordBytes(partOfSpeech, word);
                try {
                    this.probabilitiesDB.put(posWordBytes, ByteBuffer.allocate(8).putDouble(entry.getValue()).array());
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        InMemorySuffixDataStore inMemory() {
            InMemorySuffixDataStore inMemory = new InMemorySuffixDataStore();
            try (RocksIterator rocksIterator = this.probabilitiesDB.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    Pair<PartOfSpeech, String> posWord = RocksDbDataStoreFactory.getPosWordFromBytes(rocksIterator.key());
                    double prob = ByteBuffer.wrap(rocksIterator.value()).getDouble();
                    inMemory.addProbability(posWord.getSecond(), posWord.getFirst(), prob);
                    rocksIterator.next();
                }
            }
            return inMemory;
        }

        @Override
        public void write() {
        }
    }

    private static class InMemoryKnownWordDataStore
    implements KnownWordsDataStore {
        private Map<Pair<PartOfSpeech, String>, Double> probabilities = new HashMap<Pair<PartOfSpeech, String>, Double>();
        private Map<String, List<PartOfSpeech>> candidates = new HashMap<String, List<PartOfSpeech>>();

        private InMemoryKnownWordDataStore() {
        }

        @Override
        @Nullable
        public Double getProbability(String word, PartOfSpeech candidate) {
            return this.probabilities.get(Pair.of(candidate, word));
        }

        @Override
        public List<PartOfSpeech> getCandidates(String word) {
            return this.candidates.get(word);
        }

        @Override
        public boolean isKnown(String word) {
            return this.candidates.get(word) != null;
        }

        @Override
        public void addAllProbabilities(Map<Pair<PartOfSpeech, String>, Double> lexicalProbabilities) {
            this.probabilities.putAll(lexicalProbabilities);
            for (Map.Entry<Pair<PartOfSpeech, String>, Double> entry : lexicalProbabilities.entrySet()) {
                this.candidates.compute(entry.getKey().getSecond(), InMemoryKnownWordDataStore.mmCompute(entry.getKey().getFirst()));
            }
        }

        void addProbability(String string, PartOfSpeech partOfSpeech, Double probability) {
            this.probabilities.put(Pair.of(partOfSpeech, string), probability);
            this.candidates.compute(string, InMemoryKnownWordDataStore.mmCompute(partOfSpeech));
        }

        static BiFunction<String, List<PartOfSpeech>, List<PartOfSpeech>> mmCompute(PartOfSpeech pos) {
            return (s, partOfSpeeches) -> {
                if (partOfSpeeches == null) {
                    partOfSpeeches = new ArrayList<PartOfSpeech>();
                } else if (partOfSpeeches.contains((Object)pos)) {
                    return partOfSpeeches;
                }
                partOfSpeeches.add(pos);
                return partOfSpeeches;
            };
        }

        @Override
        public void write() {
        }
    }

    private static class InMemorySuffixDataStore
    implements SuffixDataStore {
        private final Map<Pair<PartOfSpeech, String>, Double> probabilities = new HashMap<Pair<PartOfSpeech, String>, Double>();

        private InMemorySuffixDataStore() {
        }

        @Override
        @Nullable
        public Double getProbability(String suffix, PartOfSpeech candidate) {
            return this.probabilities.get(Pair.of(candidate, suffix));
        }

        @Override
        public void addAllProbabilities(TreeMap<Pair<PartOfSpeech, String>, Double> probabilities) {
            this.probabilities.putAll(probabilities);
        }

        void addProbability(String string, PartOfSpeech partOfSpeech, Double probability) {
            this.probabilities.put(Pair.of(partOfSpeech, string), probability);
        }

        @Override
        public void write() {
        }
    }
}

