/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.common.tuples.WordCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.types.syntax.PartsOfSpeech;
import edu.umn.biomedicus.common.utilities.Strings;
import edu.umn.biomedicus.tnt.DataStoreFactory;
import edu.umn.biomedicus.tnt.SuffixDataStore;
import edu.umn.biomedicus.tnt.WordCapAdapter;
import edu.umn.biomedicus.tnt.WordCapFilter;
import edu.umn.biomedicus.tnt.WordPosFrequencies;
import edu.umn.biomedicus.tnt.WordProbabilityModel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SuffixWordProbabilityModel
implements WordProbabilityModel {
    private static final Set<PartOfSpeech> PARTS_OF_SPEECH = PartsOfSpeech.getRealTags();
    private transient SuffixDataStore suffixDataStore;
    private int maxSuffixLength;
    private WordCapAdapter wordCapAdapter;
    private WordCapFilter filter;
    private int id;

    @Override
    public double logProbabilityOfWord(PartOfSpeech candidate, WordCap wordCap) {
        WordCap adapted = this.wordCapAdapter.apply(wordCap);
        return Strings.generateSuffixes(adapted.getWord(), this.maxSuffixLength).map(suffix -> this.suffixDataStore.getProbability((String)suffix, candidate)).filter(Objects::nonNull).findFirst().orElse(Double.NEGATIVE_INFINITY);
    }

    @Override
    public Set<PartOfSpeech> getCandidates(WordCap wordCap) {
        return PARTS_OF_SPEECH;
    }

    @Override
    public boolean isKnown(WordCap wordCap) {
        return this.filter.test(wordCap);
    }

    @Override
    public void createDataStore(DataStoreFactory dataStoreFactory) {
        this.suffixDataStore = dataStoreFactory.createSuffixDataStore(this.id);
    }

    @Override
    public void openDataStore(DataStoreFactory dataStoreFactory) {
        this.suffixDataStore = dataStoreFactory.openSuffixDataStore(this.id);
    }

    @Override
    public void writeData() {
        this.suffixDataStore.write();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Deprecated
    void trainMsl(WordPosFrequencies wordPosFrequencies, Set<PartOfSpeech> tagSet) {
        throw new UnsupportedOperationException("MSL model is unsupported.");
    }

    void trainPI(WordPosFrequencies wordPosFrequencies, Set<PartOfSpeech> tagSet) {
        Map<Integer, WordPosFrequencies> byWordLength = wordPosFrequencies.byWordLength();
        double[] weights = byWordLength.keySet().stream().sorted().mapToDouble(suffixLength -> {
            WordPosFrequencies ofLength = (WordPosFrequencies)byWordLength.get(suffixLength);
            Set<PartOfSpeech> partsOfSpeech = ofLength.partsOfSpeech();
            double sumOfProbabilities = partsOfSpeech.stream().mapToDouble(ofLength::probabilityOfPartOfSpeech).sum();
            double expected = sumOfProbabilities / (double)partsOfSpeech.size();
            double sampleVariable = partsOfSpeech.stream().mapToDouble(ofLength::probabilityOfPartOfSpeech).map(prob -> Math.pow(prob - expected, 2.0)).sum();
            return Math.sqrt(sampleVariable / (double)(partsOfSpeech.size() - 1));
        }).toArray();
        TreeMap<Pair<PartOfSpeech, String>, Double> probabilities = new TreeMap<Pair<PartOfSpeech, String>, Double>((o1, o2) -> {
            int compare = ((PartOfSpeech)((Object)((Object)o1.getFirst()))).compareTo((Enum)o2.getFirst());
            if (compare != 0) {
                return compare;
            }
            return ((String)o1.getSecond()).compareTo((String)o2.getSecond());
        });
        for (String word : wordPosFrequencies.getWords()) {
            for (PartOfSpeech partOfSpeech : tagSet) {
                List collect = Strings.generateSuffixes(word, this.maxSuffixLength).collect(Collectors.toList());
                double probability2 = wordPosFrequencies.probabilityOfPartOfSpeech(partOfSpeech);
                for (int i = collect.size() - 2; i >= 0; --i) {
                    double weight;
                    String suffix = (String)collect.get(i);
                    double maxLikelihood = wordPosFrequencies.probabilityOfPartOfSpeechConditionalOnWord(word, partOfSpeech);
                    probability2 = (maxLikelihood + (weight = weights[suffix.length() - 1]) * probability2) / (1.0 + weight);
                    if (probability2 == 0.0) continue;
                    probabilities.put(Pair.of(partOfSpeech, suffix), probability2);
                }
            }
        }
        probabilities.replaceAll((key, probability) -> {
            String word = (String)key.second();
            PartOfSpeech partOfSpeech = (PartOfSpeech)((Object)((Object)key.getFirst()));
            double suffixProbability = wordPosFrequencies.probabilityOfWord(word);
            double posProbability = wordPosFrequencies.probabilityOfPartOfSpeech(partOfSpeech);
            probability = posProbability != 0.0 && probability != null ? Double.valueOf(Math.log10(probability * suffixProbability / posProbability)) : null;
            return probability;
        });
        this.suffixDataStore.addAllProbabilities(probabilities);
    }

    public int getMaxSuffixLength() {
        return this.maxSuffixLength;
    }

    public void setMaxSuffixLength(int maxSuffixLength) {
        this.maxSuffixLength = maxSuffixLength;
    }

    public WordCapAdapter getWordCapAdapter() {
        return this.wordCapAdapter;
    }

    public void setWordCapAdapter(WordCapAdapter wordCapAdapter) {
        this.wordCapAdapter = wordCapAdapter;
    }

    public WordCapFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WordCapFilter filter) {
        this.filter = filter;
    }
}

