/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import com.google.inject.ProvidedBy;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.grams.Bigram;
import edu.umn.biomedicus.common.tuples.PosCap;
import edu.umn.biomedicus.common.tuples.WordCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.viterbi.CandidateProbability;
import edu.umn.biomedicus.common.viterbi.EmissionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.TransitionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.Viterbi;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.serialization.YamlSerialization;
import edu.umn.biomedicus.tnt.DataStoreFactory;
import edu.umn.biomedicus.tnt.PosCapTrigramModel;
import edu.umn.biomedicus.tnt.WordProbabilityModel;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@Singleton
@ProvidedBy(value=Loader.class)
public class TntModel
implements EmissionProbabilityModel<PosCap, WordCap>,
TransitionProbabilityModel<PosCap, Bigram<PosCap>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TntModel.class);
    private final PosCapTrigramModel posCapTrigramModel;
    private final List<WordProbabilityModel> wordModels;

    TntModel(PosCapTrigramModel posCapTrigramModel, List<WordProbabilityModel> wordModels) {
        this.posCapTrigramModel = posCapTrigramModel;
        this.wordModels = wordModels;
    }

    public void write(Path folder) throws IOException {
        Yaml yaml = YamlSerialization.createYaml();
        Files.createDirectories(folder, new FileAttribute[0]);
        Map<String, Object> store = this.posCapTrigramModel.createStore();
        yaml.dump(store, (Writer)Files.newBufferedWriter(folder.resolve("trigram.yml"), new OpenOption[0]));
        yaml.dump(this.wordModels, (Writer)Files.newBufferedWriter(folder.resolve("wordMetadata.yml"), new OpenOption[0]));
        for (WordProbabilityModel wordModel : this.wordModels) {
            wordModel.writeData();
        }
    }

    private WordProbabilityModel getWordProbabilityModel(WordCap emittedValue) {
        WordProbabilityModel filteredAdaptedWordProbability = null;
        for (WordProbabilityModel probabilityModel : this.wordModels) {
            if (!probabilityModel.isKnown(emittedValue)) continue;
            filteredAdaptedWordProbability = probabilityModel;
            break;
        }
        if (filteredAdaptedWordProbability == null) {
            throw new AssertionError((Object)"could not find any word probability model");
        }
        return filteredAdaptedWordProbability;
    }

    @Override
    public Collection<CandidateProbability<PosCap>> getCandidates(WordCap emittedValue) {
        WordProbabilityModel filteredAdaptedWordProbability = this.getWordProbabilityModel(emittedValue);
        return filteredAdaptedWordProbability.getCandidates(emittedValue).stream().map(candidate -> {
            double emissionLogProbability = filteredAdaptedWordProbability.logProbabilityOfWord((PartOfSpeech)((Object)candidate), emittedValue);
            PosCap candidatePosCap = PosCap.create(candidate, emittedValue.isCapitalized());
            return Viterbi.candidateOf(candidatePosCap, emissionLogProbability);
        }).collect(Collectors.toList());
    }

    @Override
    public double getTransitionLogProbability(Bigram<PosCap> statesReduction, PosCap candidate) {
        return Math.log10(this.posCapTrigramModel.getTrigramProbability(statesReduction.getFirst(), statesReduction.getSecond(), candidate));
    }

    @Singleton
    static class Loader
    extends DataLoader<TntModel> {
        private final Path trigram;
        private final Path wordMetadata;
        private final DataStoreFactory dataStoreFactory;

        @Inject
        public Loader(@Setting(value="tnt.trigram.asDataPath") Path trigram, @Setting(value="tnt.word.metadata.asDataPath") Path wordMetadata, DataStoreFactory dataStoreFactory) {
            this.trigram = trigram;
            this.wordMetadata = wordMetadata;
            this.dataStoreFactory = dataStoreFactory;
        }

        @Override
        protected TntModel loadModel() throws BiomedicusException {
            Yaml yaml = YamlSerialization.createYaml();
            try {
                LOGGER.info("Loading TnT trigram model: {}", (Object)this.trigram);
                Map store = (Map)yaml.load(Files.newInputStream(this.trigram, new OpenOption[0]));
                PosCapTrigramModel posCapTrigramModel = PosCapTrigramModel.createFromStore(store);
                List wordModels = (List)yaml.load(Files.newInputStream(this.wordMetadata, new OpenOption[0]));
                LOGGER.info("Loading TnT word models.");
                wordModels.forEach(wm -> wm.openDataStore(this.dataStoreFactory));
                return new TntModel(posCapTrigramModel, wordModels);
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }
    }
}

