/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.grams.Ngram;
import edu.umn.biomedicus.common.tuples.PosCap;
import edu.umn.biomedicus.common.tuples.WordCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.viterbi.Viterbi;
import edu.umn.biomedicus.common.viterbi.ViterbiProcessor;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tnt.TntModel;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class TntPosTagger
implements DocumentsProcessor {
    public static final PosCap BBS = PosCap.getNotCapitalized(PartOfSpeech.BBS);
    public static final PosCap BOS = PosCap.getNotCapitalized(PartOfSpeech.BOS);
    public static final PosCap SKIP = PosCap.getNotCapitalized(PartOfSpeech.XX);
    public static final PosCap EOS = PosCap.getNotCapitalized(PartOfSpeech.EOS);
    private final double beamThreshold;
    private final TntModel tntModel;

    @Inject
    public TntPosTagger(TntModel tntModel, @Setting(value="tnt.beam.threshold") Double beamThreshold) {
        this.tntModel = tntModel;
        this.beamThreshold = beamThreshold;
    }

    public void process(@Nonnull Document document) {
        LabelIndex sentenceLabelIndex = document.labelIndex(Sentence.class);
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        Labeler partOfSpeechLabeler = document.labeler(PosTag.class);
        for (Sentence sentence : sentenceLabelIndex) {
            LabelIndex tokens = parseTokenLabelIndex.inside((TextRange)sentence);
            ViterbiProcessor<PosCap, WordCap> viterbiProcessor = Viterbi.secondOrder(this.tntModel, this.tntModel, Ngram.create(BBS, BOS), Ngram::create);
            String docText = document.getText();
            for (ParseToken token : tokens) {
                CharSequence text = token.coveredText(docText);
                boolean isCapitalized = Character.isUpperCase(text.charAt(0));
                viterbiProcessor.advance(new WordCap(text.toString(), isCapitalized));
                viterbiProcessor.beamFilter(this.beamThreshold);
            }
            List<PosCap> tags = viterbiProcessor.end(SKIP, EOS);
            if (tokens.size() + 2 != tags.size()) {
                throw new AssertionError((Object)"Tags should be same size as number of tokens in sentence");
            }
            Iterator<PosCap> it = tags.subList(2, tags.size()).iterator();
            for (ParseToken token : tokens) {
                PartOfSpeech partOfSpeech = it.next().getPartOfSpeech();
                partOfSpeechLabeler.add((Label)new PosTag(token, partOfSpeech));
            }
        }
    }

    public void done() {
    }
}

